% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_rgb}
\alias{pal_rgb}
\title{Alternative color palette for graphs (with RGB colors).}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal_rgb
}
\description{
\code{pal_rgb} is initialized to a vector of named elements (colors)
to define an alternative (reduced) scenario color scheme
(using red, green, and blue colors).
}
\details{
See \code{\link{pal}} for default color information.

Assign \code{pal <- pal_rgb} to use as default color scheme
throughout the \bold{riskyr} package.
}
\examples{
pal_rgb        # shows all color names and current values
pal_rgb["hi"]  # shows the current color for hits (true positives, TP)
pal_rgb["hi"] <- "gold" # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other color palettes: 
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_crisk}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}}

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{pal}},
\code{\link{prob}},
\code{\link{txt_TF}},
\code{\link{txt_org}},
\code{\link{txt}}
}
\concept{color palettes}
\concept{lists containing current scenario information}
\keyword{datasets}
