% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_index_calculation.R
\name{t_index_calculation}
\alias{t_index_calculation}
\title{Calculates time-dependent index when nodes weights or barriers passability are changing}
\usage{
t_index_calculation(
  graph = graph,
  ...,
  barriers_metadata,
  id_barrier = "id_barrier",
  year = "year",
  pass_u = "pass_u",
  pass_d = "pass_d",
  weights_metadata,
  weight = "length",
  nodes_id = "name",
  parallel = TRUE,
  ncores
)
}
\arguments{
\item{graph}{an object of class igraph. Can be both directed or undirected.}

\item{...}{other arguments passed to the function index_calculation}

\item{barriers_metadata}{data.frame that must contain a column having the same name as the 'id_barrier' attribute of the graph,
and two columns with the corresponding upstream and downstream improved passabilities (see pass_u and pass_d), and a column with the year
passability was changed. This data frame can be obtained from easily-formatted data with the function \code{t_passability_sequencer}.}

\item{id_barrier}{graph edges attribute used to label barriers. Default is \code{"id_barrier"}. It should be present in the 'barriers metadata' input as well.}

\item{year}{field of the 'barriers metadata' where temporal information on the changes in passability is stored.}

\item{pass_u}{field of the 'barriers metadata' where temporal-dependent upstream passability is stored.}

\item{pass_d}{field of the 'barriers metadata' where temporal-dependent downstream passability is stored.}

\item{weights_metadata}{data.frame that must contain a column having the same name as the 'nodes_id' attribute of the graph,
a column with he corresponding weight information (see 'weight' parameter), and a column with the year
weight was changed. This data frame can be obtained from easily-formatted data with the function \code{t_weight_sequencer}.}

\item{weight}{param weight graph vertex attribute used to assign weights to the reaches (nodes). Default is \code{"length"}.}

\item{nodes_id}{graph vertex attribute used to uniquely label reaches (nodes). Default is \code{"name"}.}

\item{parallel}{logical value to flag if parallel option is to be used.}

\item{ncores}{define how many cores are used in parallel processing. Active only when \code{parallel = TRUE}}
}
\value{
a data.frame with a 'year' field and related connectivity index.
If \code{index_type = "reach"}, the data.frame is organized by 'year' and 'name'.
}
\description{
Calculates time-dependent index when nodes weights or barriers passability are changing
}
\examples{
library(igraph)
g <- igraph::graph_from_literal(1-+2, 2-+4, 3-+2, 4-+6, 6-+5)
E(g)$id_barrier <- c(NA, NA, "1", NA, NA)
E(g)$type <- ifelse(is.na(E(g)$id_barrier), "joint", "dam")
V(g)$length <- c(1, 1, 2, 3, 4,5)
V(g)$Id <- V(g)$name
E(g)$pass_u <- E(g)$pass_d <- ifelse(!is.na(E(g)$id_barrier),0.1,NA)
barriers_data <- data.frame("id_barrier" = c("1"),
   "year_c" = 2000, "pass_c_u" = 0.1, "pass_c_d" = 0.4)
seq_ops <- c("c")
barriers_metadata <- t_passability_sequencer(barriers_data, seq_ops)
weights_dataframe <- data.frame("name" = seq(1,6) \%>\% as.character,
    "length_1999" = c(1, 1, 2, 3, 4,5))
weights_metadata <- t_weights_sequencer(weights_dataframe, weight = "length")
t_index <- t_index_calculation(g, barriers_metadata = barriers_metadata,
 weights_metadata = weights_metadata, weight = "length", parallel = FALSE, B_ij_flag = FALSE)




}
\references{
Baldan, D., Cunillera-Montcusí, D., Funk, A., & Hein, T. (2022). Introducing ‘riverconn’: an R package to assess river connectivity indices. Environmental Modelling & Software, 156, 105470.
}
