% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{matbysurveylist}
\alias{matbysurveylist}
\title{Generate List of Distance Matrix Between Observations, for All Individuals}
\usage{
matbysurveylist(unique, survey, seg, vert, rivers, indiv = NULL,
  method = "upstream", flowconnected = FALSE, net = FALSE,
  stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{unique}{A vector of unique identifiers for each fish.}

\item{survey}{A vector of identifiers for each survey.  It is recommended to 
use a numeric or date format (see \link{as.Date}) to preserve survey order.}

\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{indiv}{A vector of unique individuals to use.  Accepting the default (\code{NULL}) will result in a matrix being returned for all unique individuals.}

\item{method}{Which general method to use.  Setting \code{method="distance"} will compute distance for each pair of observation, setting \code{method="direction"} will compute direction between each pair of observation, and setting \code{method="upstream"} will compute directional (upstream) distance between each pair of observation.  Defaults to \code{"upstream"}.}

\item{flowconnected}{Optional parameter to pass to the distance or direction calculation.  Defaults to \code{FALSE}.}

\item{net}{Optional parameter to pass to the distance or direction calculation.  Defaults to \code{FALSE}.}

\item{stopiferror}{Optional parameter to pass to the distance or direction calculation.  Defaults to \code{TRUE}.}

\item{algorithm}{Optional parameter to pass to the distance or direction calculation.  Defaults to \code{NULL}.}
}
\value{
A list with each element corresponding to a unique fish.  Each list element is the output from either \link{riverdistancematbysurvey}, \link{riverdirectionmatbysurvey}, or \link{upstreammatbysurvey}.
}
\description{
Returns a list of matrices, each giving the river distance, direction, or upstream travel distance between all observations of
  one unique fish.  This function is principally intended for producing an object to plot in \link{plotmatbysurveylist}.
}
\note{
Building routes from the river mouth to each river network segment may 
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, smallset)
matbysurveylist <- matbysurveylist(unique=smallset$id, survey=smallset$flight, seg=smallset$seg, 
   vert=smallset$vert, rivers=Gulk)
plotmatbysurveylist(matbysurveylist)
plotmatbysurveylist(matbysurveylist,type="confint")
plotmatbysurveylist(matbysurveylist,type="dotplot")
   
data(fakefish)
# matbysurveylist <- matbysurveylist(unique=fakefish$fish.id, survey=fakefish$flight, 
#   seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)
# plotmatbysurveylist(matbysurveylist)
}
\author{
Matt Tyers
}
\seealso{
\link{riverdistance}, \link{riverdirection}, \link{upstream}, \link{riverdistancematbysurvey}, \link{riverdirectionmatbysurvey}, \link{upstreammatbysurvey}, \link{plotmatbysurveylist}
}

