% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_riverdistance.R
\name{homerange}
\alias{homerange}
\title{Home Range}
\usage{
homerange(unique, seg, vert, rivers, map = FALSE, algorithm = NULL,
  main = NULL, ...)
}
\arguments{
\item{unique}{A vector of unique identifiers for each fish.}

\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{map}{Boolean (defaults to FALSE) Whether to produce sanity-check maps
of observed locations and calculated home range for each fish.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}

\item{main}{Plot title, if \code{map} is set to \code{TRUE}.  If unspecified, the unique ID will be used for the title.}

\item{...}{Additional plotting arguments, if \code{map} is set to \code{TRUE}.}
}
\value{
A data frame with two columns: \code{$ID} is a list of unique fish
  (as specified by \code{unique=}), and \code{$range} is calculated minimum
  home range, in the units of the coordinate system (this will likely be
  meters).
}
\description{
Returns the minimum observed home range for multiple
  observations of each individual fish.
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)
homerange(unique=fakefish$fish.id, seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)

# mapping shown just for fish 15
homerange(unique=fakefish$fish.id[fakefish$fish.id==15], seg=fakefish$seg[fakefish$fish.id==15],
          vert=fakefish$vert[fakefish$fish.id==15], rivers=Gulk, map=TRUE)
}
\author{
Matt Tyers
}

