% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segs_direction.R
\name{sequenceverts}
\alias{sequenceverts}
\title{Store Vertices in Ascending Sequence}
\usage{
sequenceverts(rivers)
}
\arguments{
\item{rivers}{The river network object to use}
}
\value{
A new river network object (see \link{rivernetwork})
}
\description{
Rearranges the vertices of a river network object so that 
  vertices are stored sequentially moving up river for all segments 
  (coordinates [1,] are the bottom of each segment).
}
\note{
Even without calling \code{sequenceverts}, the vertices will be stored 
  sequentially - either moving up river or down for a given segment.  What 
  \code{sequenceverts()} adds is a standardized direction.
  
  Currently, no function in package 'riverdist' requires the vertices to be stored 
  sequentially.
}
\examples{
data(Gulk)
Gulk <- setmouth(seg=1, vert=1, rivers=Gulk)
str(Gulk)

Gulk.dir <- sequenceverts(rivers=Gulk)
str(Gulk.dir)
}
\author{
Matt Tyers
}
\seealso{
\link{line2network}
}

