% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{plot.rivernetwork}
\alias{mapriver}
\alias{plot.rivernetwork}
\title{Plotting a River Network}
\usage{
\method{plot}{rivernetwork}(x, segmentnum = TRUE, offset = TRUE, lwd = 1,
  cex = 0.6, scale = TRUE, color = TRUE, empty = FALSE, xlab = "",
  ylab = "", ...)
}
\arguments{
\item{x}{The river network object to plot}

\item{segmentnum}{Whether or not to plot segment numbers (defaults to TRUE)}

\item{offset}{Whether to offset segment numbers from lines (defaults to TRUE)}

\item{lwd}{Line width}

\item{cex}{Global character expansion factor for plotting}

\item{scale}{Whether or not to give x- and y-axes the same scale}

\item{color}{How to differentiate segments.  If \code{color==TRUE} (default),
segments will be drawn in solid lines with differing colors.  If
\code{color==FALSE}, segments will be drawn in black with differing line
types.}

\item{empty}{Creates an empty plot if set to \code{TRUE}.  Suppresses differentiation by line type if \code{color==FALSE}, and suppresses segment number labels.  Defaults to \code{FALSE}.}

\item{xlab}{Label for X-axis (defaults to "")}

\item{ylab}{Label for Y-axis (defaults to "")}

\item{...}{Additional plotting arguments (see \link[graphics]{par})}
}
\description{
S3 plotting method for the \link{rivernetwork-class}.  Produces a map of all river segments of a river network object.
}
\note{
This function is intended to provide basic visual checks for the user,
  not for any real mapping.
}
\examples{
data(Gulk)
plot(x=Gulk)
}
\author{
Matt Tyers
}

