% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_io.R
\name{rxp_file}
\alias{rxp_file}
\title{Generic Nix expression builder for R, Python, and Julia data readers}
\usage{
rxp_file(
  lang,
  name,
  path,
  read_function,
  user_functions = "",
  nix_env = "default.nix",
  env_var = NULL,
  encoder = NULL
)
}
\arguments{
\item{lang}{\code{"R"}, \code{"Py"} or \code{"Jl"}.}

\item{name}{Symbol, the name of the derivation.}

\item{path}{Character, the file path to include (e.g., "data/mtcars.shp") or
a folder path (e.g., "data"). See details.}

\item{read_function}{Function, an R function to read the data, taking one
argument (the path). This can be a user-defined function that is made available
using \code{user_functions}. See details.}

\item{user_functions}{Character vector, user-defined functions to include.
This should be a script (or scripts) containing user-defined functions
to include during the build process for this derivation. It is recommended
to use one script per function, and only include the required script(s) in
the derivation.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{env_var}{List, defaults to NULL. A named list of environment variables
to set before running the R script, e.g., c(VAR = "hello"). Each entry will
be added as an export statement in the build phase.}

\item{encoder}{Function/character, defaults to NULL.
A language-specific serializer to write the loaded object to disk.
\itemize{
\item R: function/symbol/character (e.g., \code{qs::qsave}) taking \verb{(object, path)}. Defaults to \code{saveRDS}.
\item Python: character name of a function taking \verb{(object, path)}. Defaults to using \code{pickle.dump}.
\item Julia: character name of a function taking \verb{(object, path)}. Defaults to using \code{Serialization.serialize}.
}}
}
\value{
An object of class \code{rxp_derivation}.
}
\description{
You should not call it directly, but instead use one of \code{rxp_r_file()},
\code{rxp_py_file()} or \code{rxp_jl_file()}.
}
\details{
Creates a Nix derivation that reads a file or folder of data using R,
Python, or Julia. Handles user-defined functions, environment variables, and Nix
environment specification.
}
\keyword{internal}
