% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_gc.R
\name{rxp_gc}
\alias{rxp_gc}
\title{Garbage Collect Rixpress Build Artifacts and Logs}
\usage{
rxp_gc(
  keep_since = NULL,
  project_path = ".",
  dry_run = FALSE,
  timeout_sec = 300,
  verbose = FALSE,
  ask = TRUE
)
}
\arguments{
\item{keep_since}{Date or character string (YYYY-MM-DD format). If provided,
only build logs older than this date will be targeted for deletion, along
with their associated Nix store paths. If \code{NULL}, performs a full
Nix garbage collection. Default is \code{NULL}.}

\item{project_path}{Character string specifying the path to the project
directory containing the \code{_rixpress} folder with build logs.
Default is \code{"."} (current directory).}

\item{dry_run}{Logical. If \code{TRUE}, shows what would be deleted without
actually performing any deletions. Useful for previewing the cleanup
operation. Default is \code{FALSE}.}

\item{timeout_sec}{Numeric. Timeout in seconds for individual Nix commands.
Also used for concurrency lock expiration. Default is 300 seconds.}

\item{verbose}{Logical. If \code{TRUE}, provides detailed output including
full paths, command outputs, and diagnostic information about references
preventing deletion. Default is \code{FALSE}.}

\item{ask}{Logical. If \code{TRUE}, ask for user confirmation before
performing deleting artifacts. Default is \code{TRUE}.}
}
\value{
Invisibly returns a list with cleanup summary information:
\itemize{
\item \code{kept}: Vector of build log filenames that were kept
\item \code{deleted}: Vector of build log filenames targeted for deletion
\item \code{protected}: Number of store paths protected via GC roots (date-based mode)
\item \code{deleted_count}: Number of store paths successfully deleted
\item \code{failed_count}: Number of store paths that failed to delete
\item \code{referenced_count}: Number of store paths skipped due to references
\item \code{log_files_deleted}: Number of build log files successfully deleted
\item \code{log_files_failed}: Number of build log files that failed to delete
\item \code{dry_run_details}: List of detailed information when dry_run = TRUE
}
}
\description{
This function performs garbage collection on Nix store paths and build log files
generated by rixpress. It can operate in two modes: full garbage collection
(when \code{keep_since = NULL}) or targeted deletion based on log file age.
}
\details{
The function operates in two modes:

\strong{Full Garbage Collection Mode} (\code{keep_since = NULL}):
\itemize{
\item Runs \code{nix-store --gc} to delete all unreferenced store paths
\item Does not delete any build log files
\item Suitable for complete cleanup of unused Nix store paths
}

\strong{Targeted Deletion Mode} (\code{keep_since} specified):
\itemize{
\item Identifies build logs older than the specified date
\item Extracts store paths from old logs using \code{rxp_inspect()}
\item Protects recent store paths by creating temporary GC roots
\item Attempts to delete old store paths individually using \code{nix-store --delete}
\item Deletes the corresponding build log \code{.json} files from \code{_rixpress/}
\item Handles referenced paths gracefully (paths that cannot be deleted due to dependencies)
}

\strong{Concurrency Safety:}
The function uses a lock file mechanism to prevent multiple instances from
running simultaneously, which could interfere with each other's GC root management.

\strong{Reference Handling:}
Some store paths may not be deletable because they are still referenced by:
\itemize{
\item User or system profile generations
\item Active Nix shell environments
\item Result symlinks in project directories
\item Other store paths that depend on them
}
These paths are reported but not considered errors.
}
\examples{
\dontrun{
# Preview what would be deleted (dry run)
rxp_gc(keep_since = "2025-08-01", dry_run = TRUE, verbose = TRUE)

# Delete artifacts from builds older than August 1st, 2025
rxp_gc(keep_since = "2025-08-01")

# Full garbage collection of all unreferenced store paths
rxp_gc()

# Clean up artifacts older than 30 days ago
rxp_gc(keep_since = Sys.Date() - 30)
}

}
\seealso{
\code{\link{rxp_list_logs}}, \code{\link{rxp_inspect}}

Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
