/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.Utils;

class XmlOutputArchive
implements OutputArchive {
    private PrintStream stream;
    private int indent = 0;
    private Stack<String> compoundStack;

    private void putIndent() {
        StringBuilder sb = new StringBuilder("");
        for (int idx = 0; idx < this.indent; ++idx) {
            sb.append("  ");
        }
        this.stream.print(sb.toString());
    }

    private void addIndent() {
        ++this.indent;
    }

    private void closeIndent() {
        --this.indent;
    }

    private void printBeginEnvelope(String tag) {
        if (!this.compoundStack.empty()) {
            String s = this.compoundStack.peek();
            if ("struct".equals(s)) {
                this.putIndent();
                this.stream.print("<member>\n");
                this.addIndent();
                this.putIndent();
                this.stream.print("<name>" + tag + "</name>\n");
                this.putIndent();
                this.stream.print("<value>");
            } else if ("vector".equals(s)) {
                this.stream.print("<value>");
            } else if ("map".equals(s)) {
                this.stream.print("<value>");
            }
        } else {
            this.stream.print("<value>");
        }
    }

    private void printEndEnvelope(String tag) {
        if (!this.compoundStack.empty()) {
            String s = this.compoundStack.peek();
            if ("struct".equals(s)) {
                this.stream.print("</value>\n");
                this.closeIndent();
                this.putIndent();
                this.stream.print("</member>\n");
            } else if ("vector".equals(s)) {
                this.stream.print("</value>\n");
            } else if ("map".equals(s)) {
                this.stream.print("</value>\n");
            }
        } else {
            this.stream.print("</value>\n");
        }
    }

    private void insideVector(String tag) {
        this.printBeginEnvelope(tag);
        this.compoundStack.push("vector");
    }

    private void outsideVector(String tag) throws IOException {
        String s = this.compoundStack.pop();
        if (!"vector".equals(s)) {
            throw new IOException("Error serializing vector.");
        }
        this.printEndEnvelope(tag);
    }

    private void insideMap(String tag) {
        this.printBeginEnvelope(tag);
        this.compoundStack.push("map");
    }

    private void outsideMap(String tag) throws IOException {
        String s = this.compoundStack.pop();
        if (!"map".equals(s)) {
            throw new IOException("Error serializing map.");
        }
        this.printEndEnvelope(tag);
    }

    private void insideRecord(String tag) {
        this.printBeginEnvelope(tag);
        this.compoundStack.push("struct");
    }

    private void outsideRecord(String tag) throws IOException {
        String s = this.compoundStack.pop();
        if (!"struct".equals(s)) {
            throw new IOException("Error serializing record.");
        }
        this.printEndEnvelope(tag);
    }

    static XmlOutputArchive getArchive(OutputStream strm) {
        return new XmlOutputArchive(strm);
    }

    public XmlOutputArchive(OutputStream out) {
        this.stream = new PrintStream(out);
        this.compoundStack = new Stack();
    }

    public void writeByte(byte b, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<ex:i1>");
        this.stream.print(Byte.toString(b));
        this.stream.print("</ex:i1>");
        this.printEndEnvelope(tag);
    }

    public void writeBool(boolean b, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<boolean>");
        this.stream.print(b ? "1" : "0");
        this.stream.print("</boolean>");
        this.printEndEnvelope(tag);
    }

    public void writeInt(int i, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<i4>");
        this.stream.print(Integer.toString(i));
        this.stream.print("</i4>");
        this.printEndEnvelope(tag);
    }

    public void writeLong(long l, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<ex:i8>");
        this.stream.print(Long.toString(l));
        this.stream.print("</ex:i8>");
        this.printEndEnvelope(tag);
    }

    public void writeFloat(float f, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<ex:float>");
        this.stream.print(Float.toString(f));
        this.stream.print("</ex:float>");
        this.printEndEnvelope(tag);
    }

    public void writeDouble(double d, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<double>");
        this.stream.print(Double.toString(d));
        this.stream.print("</double>");
        this.printEndEnvelope(tag);
    }

    public void writeString(String s, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<string>");
        this.stream.print(Utils.toXMLString(s));
        this.stream.print("</string>");
        this.printEndEnvelope(tag);
    }

    public void writeBuffer(byte[] buf, String tag) throws IOException {
        this.printBeginEnvelope(tag);
        this.stream.print("<string>");
        this.stream.print(Utils.toXMLBuffer(buf));
        this.stream.print("</string>");
        this.printEndEnvelope(tag);
    }

    public void writeRecord(Record r, String tag) throws IOException {
        r.serialize(this, tag);
    }

    public void startRecord(Record r, String tag) throws IOException {
        this.insideRecord(tag);
        this.stream.print("<struct>\n");
        this.addIndent();
    }

    public void endRecord(Record r, String tag) throws IOException {
        this.closeIndent();
        this.putIndent();
        this.stream.print("</struct>");
        this.outsideRecord(tag);
    }

    public void startVector(List v, String tag) throws IOException {
        this.insideVector(tag);
        this.stream.print("<array>\n");
        this.addIndent();
    }

    public void endVector(List v, String tag) throws IOException {
        this.closeIndent();
        this.putIndent();
        this.stream.print("</array>");
        this.outsideVector(tag);
    }

    public void startMap(TreeMap v, String tag) throws IOException {
        this.insideMap(tag);
        this.stream.print("<array>\n");
        this.addIndent();
    }

    public void endMap(TreeMap v, String tag) throws IOException {
        this.closeIndent();
        this.putIndent();
        this.stream.print("</array>");
        this.outsideMap(tag);
    }
}

