% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{is_lang}
\alias{is_lang}
\alias{is_unary_lang}
\alias{is_binary_lang}
\title{Is object a call?}
\usage{
is_lang(x, name = NULL, n = NULL, ns = NULL)

is_unary_lang(x, name = NULL, ns = NULL)

is_binary_lang(x, name = NULL, ns = NULL)
}
\arguments{
\item{x}{An object to test. If a formula, the right-hand side is
extracted.}

\item{name}{An optional name that the call should match. It is
passed to \code{\link[=sym]{sym()}} before matching. This argument is vectorised
and you can supply a vector of names to match. In this case,
\code{is_lang()} returns \code{TRUE} if at least one name matches.}

\item{n}{An optional number of arguments that the call should
match.}

\item{ns}{The namespace of the call. If \code{NULL}, the namespace
doesn't participate in the pattern-matching. If an empty string
\code{""} and \code{x} is a namespaced call, \code{is_lang()} returns
\code{FALSE}. If any other string, \code{is_lang()} checks that \code{x} is
namespaced within \code{ns}.}
}
\description{
This function tests if \code{x} is a call (or \link[=lang]{language
object}). This is a pattern-matching predicate that will
return \code{FALSE} if \code{name} and \code{n} are supplied and the call does not
match these properties. \code{is_unary_lang()} and \code{is_binary_lang()}
hardcode \code{n} to 1 and 2.
}
\examples{
is_lang(quote(foo(bar)))

# You can pattern-match the call with additional arguments:
is_lang(quote(foo(bar)), "foo")
is_lang(quote(foo(bar)), "bar")
is_lang(quote(foo(bar)), quote(foo))

# Match the number of arguments with is_lang():
is_lang(quote(foo(bar)), "foo", 1)
is_lang(quote(foo(bar)), "foo", 2)

# Or more specifically:
is_unary_lang(quote(foo(bar)))
is_unary_lang(quote(+3))
is_unary_lang(quote(1 + 3))
is_binary_lang(quote(1 + 3))


# By default, namespaced calls are tested unqualified:
ns_expr <- quote(base::list())
is_lang(ns_expr, "list")

# You can also specify whether the call shouldn't be namespaced by
# supplying an empty string:
is_lang(ns_expr, "list", ns = "")

# Or if it should have a namespace:
is_lang(ns_expr, "list", ns = "utils")
is_lang(ns_expr, "list", ns = "base")


# The name argument is vectorised so you can supply a list of names
# to match with:
is_lang(quote(foo(bar)), c("bar", "baz"))
is_lang(quote(foo(bar)), c("bar", "foo"))
is_lang(quote(base::list), c("::", ":::", "$", "@"))
}
\seealso{
\code{\link[=is_expr]{is_expr()}}
}
