% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_expr}
\alias{quo_expr}
\alias{quo_label}
\alias{quo_text}
\alias{quo_name}
\title{Splice a quosure and format it into string or label}
\usage{
quo_expr(quo, warn = FALSE)

quo_label(quo)

quo_text(quo, width = 60L, nlines = Inf)

quo_name(quo)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{warn}{Whether to warn if the quosure contains other quosures
(those will be collapsed).}

\item{width}{Width of each line.}

\item{nlines}{Maximum number of lines to extract.}
}
\description{
\code{quo_expr()} flattens all quosures within an expression. I.e., it
turns \code{~foo(~bar(), ~baz)} to \code{foo(bar(), baz)}. \code{quo_text()} and
\code{quo_label()} are equivalent to \code{\link[=f_text]{f_text()}}, \code{\link[=expr_label]{expr_label()}}, etc,
but they first splice their argument using \code{quo_expr()}.
\code{quo_name()} transforms a quoted symbol to a string. It adds a bit
more intent and type checking than simply calling \code{quo_text()} on
the quoted symbol (which will work but won't return an error if not
a symbol).
}
\examples{
quo <- quo(foo(!! quo(bar)))
quo

# quo_expr() unwraps all quosures and returns a raw expression:
quo_expr(quo)

# This is used by quo_text() and quo_label():
quo_text(quo)

# Compare to the unwrapped expression:
expr_text(quo)

# quo_name() is helpful when you need really short labels:
quo_name(quo(sym))
quo_name(quo(!! sym))
}
\seealso{
\code{\link[=expr_label]{expr_label()}}, \code{\link[=f_label]{f_label()}}
}
