% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_bars}
\alias{lc_bars}
\title{Create a barplot}
\usage{
lc_bars(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  addLayer = FALSE
)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced unless \code{addLayer = TRUE}. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, will be set to \code{LayerN}, where \code{N - 1}
is the number of currently existing layers in this chart.}

\item{addLayer}{if there is already a chart with the same ID, this argument defines whether to replace it or to add a
new layer to it. This argument is ignored if both \code{place} and \code{chartId} are \code{NULL} or if there is no
chart with the given ID.}
}
\description{
\code{lc_bars} creates a new barplot and adds it to the app and to the all currently opened pages
as a new chart or as a new layer of an existing chart.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{value} - heights of bars/stacks.
\item \code{stackIds} - IDs of all stacks (\emph{optional}). Must be the same size as \code{values}.
\item \code{barIds} - IDs of all bars (\emph{optional}). Must be the same size as \code{values}.
\item \code{groupIds} - IDs of all groups (\emph{optional}). Must be the same size as \code{values}.
\item \code{groupWidth} - ratio of width of a group of bars to the space, available to the group. }

Style settings
\itemize{
\item \code{opacity} - opacity of each bar|stack in the range from 0 to 1.
\item \code{colour} - colour of each bar|stack. Must be a colour name or hexadecimal code.
\item \code{colourValue} - grouping values for different colours. Can be numbers or characters.
\item \code{colourDomain} - vector of all possible values for discrete colour scales
or range of all possible colour values for the continuous ones.
\item \code{palette} - vector of colours to construct the colour scale.
\item \code{colourLegendTitle} - title for the colour legend.
\item \code{addColourScaleToLegend} - whether or not to show colour legend for the current layer.
\item \code{globalColourScale} - whether or not to use one colour scale for all the layers.
\item \code{stroke} -  stroke colour of each bar|stack. Must be a colour name or hexadecimal code.
\item \code{strokeWidth} - width of the strokes of each bar|stack. }

Axes settings
\itemize{
\item \code{logScaleX, logScaleY} - a base of logarithm for logarithmic scale transformation.
If 0 or \code{FALSE} no transformation will be performed.
\item \code{layerDomainX, layerDomainY} - default axes ranges for the given layer.
\item \code{domainX, domainY} - default axes ranges for the entire chart. If not defined,
is automatically set to include all layer domains.
\item \code{contScaleX, contScaleY} - whether or not the axis should be continuous.
\item \code{aspectRatio} - aspect ratio.
\item \code{axisTitleX, axisTitleY} - axes titles.
\item \code{axisTitlePosX, axisTitlePosY} - position of axes titles. For each axis one can specify title position
across or along the corresponding axis. Possible options are \code{"up"} (for title inside the plotting area)
or \code{"down"} (outside the plotting area, under the axis), and
\code{"start"}, \code{"middle"}, \code{"end"}. This property must be a string with one or two of the abovementioned options
(e.g. \code{"middle down"}, \code{"start"}, etc.).
\item \code{ticksRotateX, ticksRotateY} - angle by which to rotate ticks (in degrees). Must be between
0 (horizontal ticks, default) and 90 (vertical ticks).
\item \code{ticksX, ticksY} - set of ticks for the axes.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the bars is clicked. Gets an
index of the clicked bar as an argument.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the bars.
Gets an index of the clicked bar as an argument.
\item \code{on_mouseout} - function, to be called, when mouse moves out of one of the bars.
\item \code{on_marked} - function, to be called, when any of the bars are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked bars. To mark bars,
select them with your mouse while holding the \emph{Shift} key.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the instrument panel (grey triangle in the upper-left corner of the chart).
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.}
}

\examples{
\donttest{data("esoph")

lc_bars(dat(value = tapply(esoph$ncases, esoph$agegp, sum), 
            title = "Number of cases per age group",
            axisTitleX = "Age group", 
            axisTitleY = "Number of esophageal cases",
            axisTitlePosX = "down"))

lc_bars(dat(value = c(tapply(esoph$ncases, esoph$agegp, sum), 
                      tapply(esoph$ncontrols, esoph$agegp, sum)),
            stackIds = c(rep("case", 6), rep("control", 6))))

#It is easy to put data in a convenient form for barplots using tidyverse
library(magrittr)
library(dplyr)
library(tidyr)
library(stringr)

esoph \%>\%
  gather(type, cases, (ncases:ncontrols)) \%>\%
  mutate(type = str_sub(type, 2, -2)) \%>\%
  group_by(agegp, alcgp, type) \%>\%
  summarise(ncases = sum(cases)) -> newData

lc_bars(dat(value = newData$ncases,
            stackIds = newData$type,
            barIds = newData$alcgp,
            groupIds = newData$agegp))}

}
