% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumspanningtree.R
\name{MinCostArborescence}
\alias{MinCostArborescence}
\title{Solver for Minimum Cost Arborescence}
\usage{
MinCostArborescence(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  numNodes,
  algorithm = "MinCostArborescence"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of nodes of a
graph's edges}

\item{sourceNode}{The source node}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "MinCostArborescence".
"MinCostArborescence" is the default.}
}
\value{
A list containing three entries: 1) A vector corresponding the
  source nodes of the edges in the tree, 2) a vector corresponding the
  target nodes of the edges in the tree, and 3) the total cost of the
  arborescence.
}
\description{
Finds the minimum cost arborescence of a graph, returning both the cost and
the pairs of nodes for the edges in the arborescence.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00264.html}.
}
