% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{paths}
\alias{paths}
\title{Generator of a set of lfsm paths.}
\usage{
paths(N_var, parallel, seed_list = rep(x = NA, times = N_var), ...)
}
\arguments{
\item{N_var}{number of lfsm paths to generate}

\item{parallel}{a TRUE/FALSE flag which determines if the paths will be created in parallel or sequentially}

\item{seed_list}{a numerical vector of seeds to pass to \code{\link{path}}}

\item{...}{arguments to pass to path}
}
\description{
It is essentially a wrapper for \code{\link{path}} generator, which exploits the latest to create a matrix with paths in its columns.
}
\examples{
m<-45; M<-60; N<-2^10-M
alpha<-1.8; H<-0.8; sigma<-0.3
freq='L'
r=1; k=2; p=0.4

Y<-paths(N_var=10,parallel=TRUE,N=N,m=m,M=M,
         alpha=alpha,H=H,sigma=sigma,freq='L',
         disable_X=FALSE,levy_increments=NULL)

Hs<-apply(Y,MARGIN=2,H_hat,p=p,k=k)
hist(Hs)

}
\seealso{
\code{\link{path}}
}
