% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{R_hl}
\alias{R_hl}
\title{R high /low}
\usage{
R_hl(p, k, path)
}
\arguments{
\item{p}{power}

\item{k}{increment order}

\item{path}{sample path of lfsm on which the inference is to be performed}
}
\description{
Defined as
\deqn{R_{\textnormal{high}} (p,k)_n := \frac{\sum_{i=2k}^n \left| \Delta_{i,k}^{n,2} X \right|^p}
{\sum_{i=k}^n \left| \Delta_{i,k}^{n,1} X \right|^p}, \qquad}
\deqn{R_{\textnormal{low}} (p,k)_n := \frac{\sum_{i=2k}^n \left| \Delta_{i,k}^{2} X \right|^p}
{\sum_{i=k}^n \left| \Delta_{i,k}^{1} X \right|^p}}
}
\details{
The computation procedure for high- and low frequency cases is the same, since there is no way to control frequency given a sample path.
}
\examples{
m<-45; M<-60; N<-2^10-M
alpha<-0.8; H<-0.8; sigma<-0.3
p<-0.3; k=3

lfsm<-path(N=N,m=m,M=M,alpha=alpha,H=H,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm
R_hl(p=p,k=k,path=lfsm)
}
\references{
\insertRef{MOP18}{rlfsm}
}
