% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getGeneValues}
\alias{getGeneValues}
\title{Get gene expression values from list of expression matrices.}
\usage{
getGeneValues(
  list,
  gene,
  use.cols = FALSE,
  methylation.indices = NULL,
  log2scale = FALSE,
  scale.factor = 10000
)
}
\arguments{
\item{list}{List of gene x cell (or cell x gene) matrices}

\item{gene}{Gene for which to return values (if gene is not found in appropriate dimnames will
return vector of NA).}

\item{use.cols}{Whether to query columns for desired gene (set to TRUE if matrices are cell x 
gene) (default FALSE).}

\item{methylation.indices}{Indices of datasets with methylation data (never log2scaled) 
(default NULL).}

\item{log2scale}{Whether to log2+1 scale (with multiplicative factor) values (default FALSE).}

\item{scale.factor}{Scale factor to use with log2 scaling (default 10000).}
}
\value{
Plots to console (1-2 pages per factor)
}
\description{
Returns single vector of gene values across all datasets in list provided. Data can be in raw, 
normalized or scaled form. If matrices are in cell x gene format, set use.cols = TRUE.
}
\examples{
\dontrun{
# liger object with factorization complete
# ligerex
gene_values <- getGeneValues(ligerex@raw.data, 'MALAT1')
}
}
