% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{imputeKNN}
\alias{imputeKNN}
\title{Impute the query cell expression matrix}
\usage{
imputeKNN(
  object,
  reference,
  queries,
  knn_k = 20,
  weight = TRUE,
  norm = TRUE,
  scale = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{reference}{Dataset containing values to impute into query dataset(s).}

\item{queries}{Dataset to be augmented by imputation. If not specified, will pass in all datasets.}

\item{knn_k}{The maximum number of nearest neighbors to search. (default 20)}

\item{weight}{Whether to use KNN distances as weight matrix (default FALSE).}

\item{norm}{Whether normalize the imputed data with default parameters (default TRUE).}

\item{scale}{Whether scale but not center the imputed data with default parameters (default TRUE).}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with raw data in raw.data slot replaced by imputed data (genes by cells)
}
\description{
Impute query features from a reference dataset using KNN.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
# impute every dataset other than the reference dataset
ligerex <- imputeKNN(ligerex, reference = "y_set", weight = FALSE)
# impute only z_set dataset
ligerex <- imputeKNN(ligerex, reference = "y_set", queries = list("z_set"), knn_k = 50)
}
}
