% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotGene}
\alias{plotGene}
\title{Plot gene expression on dimensional reduction (t-SNE) coordinates}
\usage{
plotGene(
  object,
  gene,
  use.raw = FALSE,
  use.scaled = FALSE,
  scale.by = "dataset",
  log2scale = NULL,
  methylation.indices = NULL,
  plot.by = "dataset",
  set.dr.lims = FALSE,
  pt.size = 0.1,
  min.clip = NULL,
  max.clip = NULL,
  clip.absolute = FALSE,
  points.only = FALSE,
  option = "plasma",
  cols.use = NULL,
  zero.color = "#F5F5F5",
  axis.labels = NULL,
  do.legend = TRUE,
  return.plots = FALSE,
  keep.scale = FALSE
)
}
\arguments{
\item{object}{\code{liger} object. Should call runTSNE before calling.}

\item{gene}{Gene for which to plot expression.}

\item{use.raw}{Plot raw UMI values instead of normalized, log-transformed data (default FALSE).}

\item{use.scaled}{Plot values scaled across specified groups of cells (with log transformation)
(default FALSE).}

\item{scale.by}{Grouping of cells by which to scale gene (can be any factor column in cell.data
or 'none' for scaling across all cells) (default 'dataset').}

\item{log2scale}{Whether to show log2 transformed values or original normalized, raw, or scaled
values (as stored in object). Default value is FALSE if use.raw = TRUE, otherwise TRUE.}

\item{methylation.indices}{Indices of datasets in object with methylation data (this data is not
log transformed and must use normalized values). (default NULL)}

\item{plot.by}{How to group cells for plotting (can be any factor column in cell.data or 'none'
for plotting all cells in a single plot). Note that this can result in large number of plots.
Users are encouraged to use same value as for scale.by (default 'dataset').}

\item{set.dr.lims}{Whether to keep dimensional reduction coordinates consistent when multiple
plots created (default FALSE).}

\item{pt.size}{Point size for plots (default 0.1).}

\item{min.clip}{Minimum value for expression values plotted. Can pass in quantile (0-1) or
absolute cutoff (set clip.absolute = TRUE). Can also pass in vector if expecting multiple plots;
users are encouraged to pass in named vector (from levels of desired feature) to avoid
mismatches in order (default NULL).}

\item{max.clip}{Maximum value for expression values plotted. Can pass in quantile (0-1) or
absolute cutoff (set clip.absolute = TRUE). Can also pass in vector if expecting multiple plots;
users are encouraged to pass in named vector (from levels of desired feature) to avoid
mismatches in order (default NULL).}

\item{clip.absolute}{Whether to treat clip values as absolute cutoffs instead of quantiles
(default FALSE).}

\item{points.only}{Remove axes, background, and legend when plotting coordinates (default FALSE).}

\item{option}{Colormap option to use for ggplot2's scale_color_viridis (default 'plasma').}

\item{cols.use}{Vector of colors to form gradient over instead of viridis colormap (low to high).
(default NULL).}

\item{zero.color}{Color to use for zero values (no expression) (default '#F5F5F5').}

\item{axis.labels}{Vector of two strings to use as x and y labels respectively. (default NULL)}

\item{do.legend}{Display legend on plots (default TRUE).}

\item{return.plots}{Return ggplot objects instead of printing directly (default FALSE).}

\item{keep.scale}{Maintain min/max color scale across all plots when using plot.by (default FALSE)}
}
\value{
If returning single plot, returns ggplot object; if returning multiple plots; returns
  list of ggplot objects.
}
\description{
Generates plot of dimensional reduction coordinates (default t-SNE) colored by expression of
specified gene. Data can be scaled by dataset or selected feature column from cell.data (or across
all cells). Data plots can be split by feature.
}
\examples{
\dontrun{
# ligerex (liger object based on in-memory datasets), factorization complete
ligerex
ligerex <- runTSNE(ligerex)
# plot expression for CD4 and return plots
gene_plots <- plotGene(ligerex, "CD4", return.plots = TRUE)
# ligerex (liger object based on datasets in HDF5 format), factorization complete input
ligerex <- readSubset(ligerex, slot.use = "norm.data", max.cells = 5000)
gene_plots <- plotGene(ligerex, "CD4", return.plots = TRUE)
}
}
