% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotFactors}
\alias{plotFactors}
\title{Plot scatter plots of unaligned and aligned factor loadings}
\usage{
plotFactors(
  object,
  num.genes = 10,
  cells.highlight = NULL,
  plot.tsne = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should call quantileAlignSNF before calling.}

\item{num.genes}{Number of genes to display for each factor (default 10).}

\item{cells.highlight}{Names of specific cells to highlight in plot (black) (default NULL).}

\item{plot.tsne}{Plot t-SNE coordinates for each factor (default FALSE).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
Plots to console (1-2 pages per factor)
}
\description{
Generates scatter plots of factor loadings vs cells for both unaligned and aligned
(normalized) factor loadings. This allows for easier visualization of the changes made to the
factor loadings during the alignment step. Lists a subset of highly loading genes for each factor.
Also provides an option to plot t-SNE coordinates of the cells colored by aligned factor loadings.

It is recommended to call this function into a PDF due to the large number of
plots produced.
}
\examples{
\donttest{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 1)
ligerex <- quantile_norm(ligerex)
plotFactors(ligerex)
ligerex <- runTSNE(ligerex)
plotFactors(ligerex, plot.tsne = TRUE)
}
}
