% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorMarker.R
\name{getFactorMarkers}
\alias{getFactorMarkers}
\title{Find shared and dataset-specific markers}
\usage{
getFactorMarkers(
  object,
  dataset1,
  dataset2,
  factorShareThresh = 10,
  datasetSpecificity = NULL,
  logFCThresh = 1,
  pvalThresh = 0.05,
  nGenes = 30,
  printGenes = FALSE,
  verbose = getOption("ligerVerbose", TRUE),
  factor.share.thresh = factorShareThresh,
  dataset.specificity = datasetSpecificity,
  log.fc.thresh = logFCThresh,
  pval.thresh = pvalThresh,
  num.genes = nGenes,
  print.genes = printGenes
)
}
\arguments{
\item{object}{\linkS4class{liger} object with factorization results.}

\item{dataset1}{Name of first dataset. Required.}

\item{dataset2}{Name of second dataset. Required}

\item{factorShareThresh}{Numeric. Only factors with a dataset specificity
less than or equal to this threshold will be used. Default \code{10}.}

\item{datasetSpecificity}{Numeric vector. Pre-calculated dataset specificity
if available. Length should match number of all factors available. Default
\code{NULL} automatically calculates with
\code{\link{calcDatasetSpecificity}}.}

\item{logFCThresh}{Numeric. Lower log-fold change threshold for differential
expression in markers. Default \code{1}.}

\item{pvalThresh}{Numeric. Upper p-value threshold for Wilcoxon rank test for
gene expression. Default \code{0.05}.}

\item{nGenes}{Integer. Max number of genes to report for each dataset.
Default \code{30}.}

\item{printGenes}{Logical. Whether to print ordered markers passing logFC,
UMI and frac thresholds, when \code{verbose = TRUE}. Default \code{FALSE}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{factor.share.thresh, dataset.specificity, log.fc.thresh, pval.thresh, num.genes, print.genes}{\bold{Deprecated}. See Usage section for replacement.}
}
\value{
A list object consisting of the following entries:
\item{[value of `dataset1`]}{data.frame of dataset1-specific markers}
\item{shared}{data.frame of shared markers}
\item{[value of `dataset1`]}{data.frame of dataset2-specific markers}
\item{num_factors_V1}{A frequency table indicating the number of factors each
marker appears, in dataset1}
\item{num_factors_V2}{A frequency table indicating the number of factors each
marker appears, in dataset2}
}
\description{
Applies various filters to genes on the shared (\eqn{W}) and
dataset-specific (\eqn{V}) components of the factorization, before selecting
those which load most significantly on each factor (in a shared or
dataset-specific way).
}
\examples{
library(dplyr)
result <- getFactorMarkers(pbmcPlot, dataset1 = "ctrl", dataset2 = "stim")
print(class(result))
print(names(result))
result$shared \%>\% group_by(factor_num) \%>\% top_n(2, logFC)
}
