% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGroupClusterDimRed}
\alias{plotGroupClusterDimRed}
\title{Comprehensive group splited cluster plot on dimension reduction with
proportion}
\usage{
plotGroupClusterDimRed(
  object,
  useGroup = "dataset",
  useCluster = NULL,
  useDimRed = NULL,
  combinePlot = TRUE,
  droplevels = TRUE,
  relHeightMainLegend = c(5, 1),
  relHeightDRBar = c(10, 1),
  mainNRow = NULL,
  mainNCol = NULL,
  legendNRow = 1,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object with dimension reduction, grouping
variable and cluster assignment in \code{cellMeta(object)}.}

\item{useGroup}{Variable name of the group division in metadata. Default
\code{"dataset"}.}

\item{useCluster}{Name of variable in \code{cellMeta(object)}. Default
\code{NULL} uses default cluster.}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in \code{cellMeta(object)}. Default \code{NULL} use default dimRed.}

\item{combinePlot}{Whether to return combined plot. Default \code{TRUE}. If
\code{FALSE}, will return a list containing only the scatter plots.}

\item{droplevels}{Logical, whether to perform \code{\link{droplevels}()} on
the selected grouping variable. Default \code{TRUE} will not show groups that
are listed as categories but do not indeed have any cells.}

\item{relHeightMainLegend}{Relative heights of the main combination panel and
the legend at the bottom. Must be a numeric vector of 2 numbers. Default
\code{c(5, 1)}.}

\item{relHeightDRBar}{Relative heights of the scatter plot and the barplot
within each subpanel. Must be a numeric vector of 2 numbers. Default
\code{c(10, 1)}.}

\item{mainNRow, mainNCol}{Arrangement of the main plotting region, for number
of rows and columns. Default \code{NULL} will be automatically handled by
\code{\link[cowplot]{plot_grid}}.}

\item{legendNRow}{Arrangement of the legend, number of rows. Default
\code{1}.}

\item{...}{Additional graphic setting arguments passed to
\code{\link{plotDimRed}}.}
}
\value{
ggplot object when only one feature (e.g. cluster variable, gene,
factor) is set. List object when multiple of those are specified.
}
\description{
This function produces combined plot on group level (e.g. dataset, other
metadata variable like biological conditions). Scatter plot of dimension
reduction with cluster labeled is generated per group. Furthermore, a stacked
barplot of cluster proportion within each group is also combined with the
subplot of each group.
}
\examples{
plotGroupClusterDimRed(pbmcPlot)
}
\seealso{
Please refer to \code{\link{plotDimRed}},
\code{\link{.ggScatter}}, \code{\link{.ggplotLigerTheme}} for additional
graphic setting
}
