% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{calcAlignment}
\alias{calcAlignment}
\title{Calculate alignment metric after integration}
\usage{
calcAlignment(
  object,
  clustersUse = NULL,
  clusterVar = NULL,
  nNeighbors = NULL,
  cellIdx = NULL,
  cellComp = NULL,
  resultBy = c("all", "dataset", "cell"),
  seed = 1,
  k = nNeighbors,
  rand.seed = seed,
  cells.use = cellIdx,
  cells.comp = cellComp,
  clusters.use = clustersUse,
  by.cell = NULL,
  by.dataset = NULL
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with \code{\link{quantileNorm}}
already run.}

\item{clustersUse}{The clusters to consider for calculating the alignment.
Should be a vector of existing levels in \code{clusterVar}. Default
\code{NULL}. See Details.}

\item{clusterVar}{The name of one variable in \code{cellMeta(object)}.
Default \code{NULL} uses default clusters.}

\item{nNeighbors}{Number of neighbors to use in calculating alignment.
Default \code{NULL} uses \code{floor(0.01*ncol(object))}, with a lower bound
of 10 in all cases except where the total number of sampled cells is less
than 10.}

\item{cellIdx, cellComp}{Character, logical or numeric index that can
subscribe cells. Default \code{NULL}. See Details.}

\item{resultBy}{Select from \code{"all"}, \code{"dataset"} or \code{"cell"}.
On which level should the mean alignment be calculated. Default \code{"all"}.}

\item{seed}{Random seed to allow reproducible results. Default \code{1}.}

\item{k, rand.seed, cells.use, cells.comp, clusters.use}{[Deprecated] Please
see Usage for replacement.}

\item{by.cell, by.dataset}{[Defunct] Use \code{resultBy} instead.}
}
\value{
The alignment metric.
}
\description{
This metric quantifies how well-aligned two or more datasets are. We randomly
downsample all datasets to have as many cells as the smallest one. We
construct a nearest-neighbor graph and calculate for each cell how many of
its neighbors are from the same dataset. We average across all cells and
compare to the expected value for perfectly mixed datasets, and scale the
value from 0 to 1. Note that in practice, alignment can be greater than 1
occasionally.
}
\details{
\eqn{\bar{x}} is the average number of neighbors belonging to any cells' same
dataset, \eqn{N} is the number of datasets, \eqn{k} is the number of
neighbors in the KNN graph.
\deqn{1 - \frac{\bar{x} - \frac{k}{N}}{k - \frac{k}{N}}}

The selection on cells to be measured can be done in various way and
represent different scenarios:
\enumerate{
\item{By default, all cells are considered and the alignment across all
datasets will be calculated.}
\item{Select \code{clustersUse} from \code{clusterVar} to use cells from the
clusters of interests. This measures the alignment across all covered
datasets within the specified clusters.}
\item{Only Specify \code{cellIdx} for flexible selection. This measures the
alignment across all covered datasets within the specified cells. A none-NULL
\code{cellIdx} privileges over \code{clustersUse}.}
\item{Specify \code{cellIdx} and \code{cellComp} at the same time, so that
the original dataset source will be ignored and cells specified by each
argument will be regarded as from each a dataset. This measures the alignment
between cells specified by the two arguments. \code{cellComp} can contain
cells already specified in \code{cellIdx}.}
}
}
\examples{
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    pbmc <- pbmc \%>\%
    normalize \%>\%
    selectGenes \%>\%
    scaleNotCenter \%>\%
    runINMF \%>\%
    quantileNorm
    calcAlignment(pbmc)
}
}
