% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotProportion}
\alias{plotProportion}
\alias{plotProportionDot}
\alias{plotProportionBar}
\alias{plotClusterProportions}
\alias{plotProportionPie}
\title{Visualize proportion across two categorical variables}
\usage{
plotProportion(
  object,
  class1 = NULL,
  class2 = "dataset",
  method = c("stack", "group", "pie"),
  ...
)

plotProportionDot(
  object,
  class1 = NULL,
  class2 = "dataset",
  showLegend = FALSE,
  panelBorder = TRUE,
  ...
)

plotProportionBar(
  object,
  class1 = NULL,
  class2 = "dataset",
  method = c("stack", "group"),
  inclRev = FALSE,
  panelBorder = TRUE,
  combinePlot = TRUE,
  ...
)

plotClusterProportions(object, useCluster = NULL, return.plot = FALSE, ...)

plotProportionPie(
  object,
  class1 = NULL,
  class2 = "dataset",
  labelSize = 4,
  labelColor = "white",
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{class1, class2}{Each should be a single name of a categorical variable
available in \code{cellMeta} slot. Number of cells in each categories in
\code{class2} will be served as the denominator when calculating proportions.
By default \code{class1 = NULL} and uses default clusters and \code{class2 =
"dataset"}.}

\item{method}{For bar plot, choose whether to draw \code{"stack"} or
\code{"group"} bar plot. Default \code{"stack"}.}

\item{showLegend, panelBorder, ...}{ggplot theme setting arguments passed to
\code{\link{.ggplotLigerTheme}}.}

\item{inclRev}{Logical, for barplot, whether to reverse the specification for
\code{class1} and \code{class2} and produce two plots. Default \code{FALSE}.}

\item{combinePlot}{Logical, whether to combine the two plots with
\code{\link[cowplot]{plot_grid}} when two plots are created. Default
\code{TRUE}.}

\item{useCluster}{For \code{plotClusterProportions}. Same as \code{class1}
while \code{class2} is hardcoded with \code{"dataset"}.}

\item{return.plot}{\bold{defuncted}.}

\item{labelSize, labelColor}{Settings on pie chart percentage label. Default
\code{4} and \code{"white"}.}
}
\value{
ggplot or list of ggplot
}
\description{
\code{plotProportionBar} creates bar plots comparing the
cross-category proportion. \code{plotProportionDot} creates dot plots.
\code{plotClusterProportions} has variable pre-specified and calls the dot
plot. \code{plotProportion} produces a combination of both bar plots and dot
plot.

Having package "ggrepel" installed can help adding tidier percentage
annotation on the pie chart.
}
\examples{
plotProportion(pbmcPlot)
plotProportionBar(pbmcPlot, method = "group")
plotProportionPie(pbmcPlot)
}
