% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ligerDataset-methods.R
\name{isH5Liger}
\alias{isH5Liger}
\title{Check if a liger or ligerDataset object is made of HDF5 file}
\usage{
isH5Liger(object, dataset = NULL)
}
\arguments{
\item{object}{A liger or ligerDataset object.}

\item{dataset}{If \code{object} is of liger class, check a specific dataset.
If \code{NULL}, Check if all datasets are made of HDF5 file. Default
\code{NULL}.}
}
\value{
\code{TRUE} or \code{FALSE} for the specified check.
}
\description{
Check if a liger or ligerDataset object is made of HDF5 file
}
\examples{
isH5Liger(pbmc)
isH5Liger(pbmc, "ctrl")
ctrl <- dataset(pbmc, "ctrl")
isH5Liger(ctrl)
}
