% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classConversion.R
\name{updateLigerObject}
\alias{updateLigerObject}
\title{Update old liger object to up-to-date structure}
\usage{
updateLigerObject(
  object,
  dimredName,
  clusterName = "clusters",
  h5FilePath = NULL
)
}
\arguments{
\item{object}{An object of any version of rliger}

\item{dimredName}{Name of the dimension reduction embedding to be stored.
Please see Details section.}

\item{clusterName}{Name of the clustering assignment variable to be stored.
Please see Details section.}

\item{h5FilePath}{Named character vector for all H5 file paths. Not required
for object run with in-memory analysis. For object containing H5-based
analysis (e.g. online iNMF), this must be supplied if the H5 file location is
different from that at creation time.}
}
\value{
Updated liger object.
}
\description{
Due to massive updates since rliger 2.0, old liger object structures are no
longer compatible with the current package. This function will update the
object to the latest structure.
}
\details{
Old liger object (<1.99.0) stores only one embedding at slot
\code{tsne.coords}. \code{dimredName} must be specified as a single
character. Pre-release version (1.99.0) stores multiple embeddings in
\code{cellMeta}. \code{dimredName} must be exact existing variable names in
\code{cellMeta} slot.

Old liger object stores clustering assignment in slot \code{clusters}.
\code{clusterName} must be specified as a single character. Pre-release
version does not require this.
}
\examples{
\dontrun{
# Suppose you have a liger object of old version (<1.99.0)
newLig <- updateLigerObject(oldLig,
                            dimredName = "UMAP",
                            clusterName = "louvain")
}
}
