% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/list.flatten.R
\name{list.flatten}
\alias{list.flatten}
\title{Flatten a nested list to a one-level list}
\usage{
list.flatten(x, use.names = TRUE, classes = "ANY")
}
\arguments{
\item{x}{\code{list}}

\item{use.names}{\code{logical}. Should the names of \code{x} be kept?}

\item{classes}{A character vector of class names, or "ANY" to match any class.}
}
\description{
Flatten a nested list to a one-level list
}
\details{
The function is essentially a slightly modified version of \code{flatten2}
provided by Tommy at \href{http://stackoverflow.com/a/8139959/2906900}{stackoverflow.com} who
has full credit of the implementation of this function.
}
\examples{
p <- list(a=1,b=list(b1=2,b2=3),c=list(c1=list(c11='a',c12='x'),c2=3))
list.flatten(p)

p <- list(a=1,b=list(x="a",y="b",z=10))
list.flatten(p, classes = "numeric")
list.flatten(p, classes = "character")
}
\author{
\href{http://stackoverflow.com/users/662787/tommy}{Tommy}
}

