% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{NewTimeEst}
\alias{NewTimeEst}
\title{Estimate New Time Points}
\usage{
NewTimeEst(v, Subject, Time, TimeMinOut, ncores)
}
\arguments{
\item{v}{output of \code{\link[limma]{voom}} function.}

\item{Subject}{a vector of subjects or experimental units.}

\item{Time}{a vector of time points.}

\item{TimeMinOut}{output from the \code{\link{TimeMin}} function}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}
}
\value{
New time points.
}
\description{
This function estimate new time points to fit the glsCAR1
for the \code{\link[limma]{voom}} transformed data. Note that
this function is very specific for this dataset, with only
4 time points. If there are more than 4 time points, the
method needs to be updated.
}
\examples{
\donttest{
data(res)
data(covset)
v <- res$ori.res$v
v$E <- v$E[1:2,]
v$weights <- v$weights[1:2,]
Subject <- covset$ear
Time <- covset$time
ncores <- 1
NewTimeOut <- rmRNAseq:::NewTimeEst(v, Subject, Time, ncores)
NewTimeOut
}
}
