% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{glsCAR1_loglik}
\alias{glsCAR1_loglik}
\title{Calculate REML Log-Likelihood of glsCAR1 model for each gene}
\usage{
glsCAR1_loglik(d)
}
\arguments{
\item{d}{a data frame containing several columns. The first 4 columns are
\code{y:} a vector of log-counts (obtained by \code{\link[limma]{voom}}),
\code{Subject:} a vector of subject/experimental units where repeated
measures are obtained (can be either numeric or factor),  \code{Time:} a
vector of time points (continuous, since we fit
\code{\link[nlme]{corCAR1}}), \code{w:} weights to put in gls model, this is
the inverse of weights obtained by \code{\link[limma]{voom}} The other
columns are exactly the same as design matrix.}
}
\value{
reml log-likelihood value
}
\description{
This function calculates log-likelihood value of glsCAR1 for
each gene using \code{\link[limma]{voom}} data.
}
\examples{
\donttest{
data(res)
data(design)
data(covset)
d <- data.frame(cbind(y = res$ori.res$v$E[1,] ,Subject = covset$ear,
Time = covset$time, w = 1/res$ori.res$v$weights[1,], design))
glsloglikout <- rmRNAseq:::glsCAR1_loglik(d)
glsloglikout
}
}
