% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{glsSymm}
\alias{glsSymm}
\title{Fit General Linear Model with \code{corSymm} Correlation Structure for One
Gene}
\usage{
glsSymm(d)
}
\arguments{
\item{d}{a data frame containing several columns. The first 4 columns are
\code{y:} a vector of log-counts (obtained by \code{\link[limma]{voom}}),
\code{Subject:} a vector of subject/experimental units where repeated
measures are obtained (can be either numeric or factor),  \code{Time:} a
vector of time points (continuous, since we fit
\code{\link[nlme]{corSymm}}), \code{w:} weights to put in gls model, this is
the inverse of weights obtained by \code{\link[limma]{voom}} The other
columns are exactly the same as design matrix.}
}
\value{
Output is a vector including the following components
\item{aic}{AIC of the fitted model.}
\item{s2}{estimate of error variance. }
\item{rho}{correlation parameter in \code{corSymm} correlation matrix.}
\item{fixed}{fixed effects (estimates of regression parameters).}
\item{varbeta}{the estimates of variance of fixed effects, just include
 lower part and diagonal part of the variance-covariance matrix.}
}
\description{
This function  fits \code{\link[nlme]{gls}} model with REML estimation method,
\code{\link[nlme]{corSymm}} unstructured correlation for one gene in a RNA-seq
repeated measures data, where data is the log-transformed counts obtained from
\code{\link[limma]{voom}}.
}
\examples{
data(res)
data(design)
data(covset)
d <- data.frame(cbind(y = res$ori.res$v$E[1,] ,Subject = covset$ear,
Time = covset$time, w = 1/res$ori.res$v$weights[1,], design))
glsout <- rmRNAseq:::glsSymm(d)
glsout
}
