% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_map_legends.R
\name{get_map_legends}
\alias{get_map_legends}
\title{Retrieve geologic map legend data}
\usage{
get_map_legends(
  source_id = NULL,
  lithology_id = NULL,
  lithology_type = NULL,
  lithology_class = NULL,
  description = NULL,
  comments = NULL,
  scale = NULL,
  carto = NULL
)
}
\arguments{
\item{source_id}{\code{integer}. Filter legend components to those in sources
specified by their unique identification number(s).}

\item{lithology_id}{\code{integer}. Filter legend components to those
containing one or more lithology(ies) as specified by their unique
identification number(s).}

\item{lithology_type}{\code{character}. Filter legend components to those
containing one or more named lithology type(s) (e.g., "carbonate",
"siliciclastic").}

\item{lithology_class}{\code{character}. Filter legend components to those
containing one or more named lithology class(es) (e.g., "sedimentary",
"igneous", "metamorphic").}

\item{description}{\code{character}. Filter legend components to those
containing the given character string in the map unit description field.}

\item{comments}{\code{character}. Filter legend components to those
containing the given character string in the map unit comments field.}

\item{scale}{\code{character}. Filter legend components to those from maps of
specific scale(s) in Macrostrat's system. Options are "tiny" (global),
"small" (continental), "medium" (regional), or "large" (local).}

\item{carto}{\code{character}. Filter legend components to those of specific
scale(s) in Macrostrat's system. Options are "tiny" (global), "small"
(continental), "medium" (regional), or "large" (local).}
}
\value{
A \code{dataframe} containing the following columns:
\itemize{
\item \code{legend_id}: The unique identification number of the
map legend.
\item \code{source_id}: The identification number of the source geologic
map (see \code{\link[=def_sources]{def_sources()}}).
\item \code{scale}: The associated Macrostrat map scale for the legend.
\item \code{map_unit_name}:The name of the outcrop shape element as defined
in the geologic map source.
\item \code{strat_name}: The geologic name(s) of the outcrop shape element.
\item \code{age}: The chronostratigraphic bin assigned to the outcrop shape
element, as defined in the geologic map source in plain text.
\item \code{lith}: The lithology of the outcrop shape element as defined in
the geologic map source in plain text.
\item \code{descrip}: Description of the outcrop shape element in plain
text.
\item \code{comments}: Notes assigned to the outcrop shape element.
\item \code{t_age}: The estimated top age of the outcrop shape element, in
millions of years before present.
\item \code{b_age}: The estimated bottom age of the outcrop shape element,
in millions of years before present.
\item \code{b_interval}: The unique identification number of the bottom
time interval matched to the outcrop shape element.
\item \code{t_interval}: The unique identification number of the top time
interval matched to the outcrop shape element.
\item \code{strat_name_id}: A vector containing the unique identification
number(s) for known stratigraphic unit name(s) matched to the outcrop
shape element (see \code{\link[=def_strat_names]{def_strat_names()}}).
\item \code{unit_id}: A vector containing the unique identification
number(s) for known Macrostrat unit(s) matched to the outcrop shape
element.
\item \code{lith_classes}: A vector containing the named lithology
class(es) (e.g., "sedimentary") matched to the outcrop shape element.
\item \code{lith_types}: A vector containing the named lithology type(s)
(e.g., "siliciclastic") matched to the outcrop shape element.
\item \code{lith_id}: A vector containing the unique identification
number(s) for known lithology(ies) represented within the outcrop shape
element (see \code{\link[=def_lithologies]{def_lithologies()}}).
\item \code{color}: Recommended color for plotting the outcrop shape
element based on the dominant lithology.
\item \code{area}: The area of the outcrop shape element in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
\item \code{tiny_area}: The area of the outcrop shape element in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}} at "tiny" Macrostrat map
scale.
\item \code{small_area}: The area of the outcrop shape element in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}} at "small" Macrostrat map
scale.
\item \code{medium_area}: The area of the outcrop shape element in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}} at "medium" Macrostrat map
scale.
\item \code{large_area}: The area of the outcrop shape element in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}} at "large" Macrostrat map
scale.
}
}
\description{
A function to retrieve legend components from various geological
maps.
}
\details{
Potential Macrostrat map scales are "tiny" (global), "small"
(continental), "medium" (regional), or "large" (local).
}
\section{Developer(s)}{

Christopher D. Dean
}

\section{Reviewer(s)}{

William Gearty
}

\examples{
\donttest{
 # Get legend components by ID of the original source map
 ex1 <- get_map_legends(source_id = 1)
 # Get legend components for any sedimentary lithologies
 ex2 <- get_map_legends(lithology_type = "sedimentary")
 # Get any legend components that have comments with the word 'breccia'
 ex3 <- get_map_legends(comments = "breccia")
}
}
\seealso{
Geologic maps:
\code{\link{def_sources}()},
\code{\link{get_map_outcrop}()},
\code{\link{get_map_points}()}
}
\concept{maps}
