% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_interactions.R
\name{search_interactions}
\alias{search_interactions}
\title{Query interactions}
\usage{
search_interactions(
  query,
  type = NULL,
  expand_node = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{either a character string including a single keyword or a list containing a custom query (see details section below).
Note that if an empty character string is passed, then all datasets available are returned.}

\item{type}{a \code{character} one of the interactions type available, uses \code{\link[=avail_type]{avail_type()}} to see the full list of type available. Note that \code{query} is ignored if \code{type} is used.}

\item{expand_node}{a logical. Should the function returned extra information pertaining to nodes? Default is set to \code{FALSE}, which means that only the Mangal IDs of nodes are returned.}

\item{verbose}{a \code{logical}. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
An object of class \code{mgSearchInteractions}, i.e. a \code{data.frame} object including interactions.
All networks in which interactions are involved are also attached to the \code{data.frame}.
}
\description{
Search for specific interactions using a keyword or a specific type of
interactions (e.g. mutualism). If the \code{query} is a character string, then all character columns in the table
are searched and the entries for which at least one
partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a specific column (see Details section)
}
\details{
Names of the list should match one of the column names within the table.
For the \code{interaction} table, those are:
\itemize{
\item id: unique identifier of the interaction
\item attr_id: identifier of a specific attribute
\item direction: edge direction ("directed", "undirected" or "unknown")
\item network_id: Mangal network identifier
\item node_from: node id which the interaction end to
\item node_to: node to which the interaction end to
\item type: use argument \code{type} instead
}

Note that for lists with more than one element, only the first element is used, the others are ignored.
Examples covering custom queries are provided below.
}
\examples{
df_inter <- search_interactions(type = "competition", verbose = FALSE)
# Get all networks containing competition
\donttest{
competition_networks <- get_collection(df_inter, verbose = FALSE)
}
df_net_926 <- search_interactions(list(network_id = 926), verbose = FALSE)
}
\references{
Metadata available at \url{https://mangal-wg.github.io/mangal-api/#interactions}
}
