% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network_by_id.R
\name{get_network_by_id}
\alias{get_network_by_id}
\alias{get_network_by_id_indiv}
\alias{print.mgNetwork}
\alias{print.mgNetworksCollection}
\alias{summary.mgNetwork}
\alias{summary.mgNetworksCollection}
\title{Retrieve network information, nodes, edges and references for a given set of Mangal network IDs}
\usage{
get_network_by_id(ids, as_sf = FALSE, force_collection = FALSE, verbose = TRUE)

get_network_by_id_indiv(id, as_sf = FALSE, verbose = TRUE)

\method{print}{mgNetwork}(x, ...)

\method{print}{mgNetworksCollection}(x, ...)

\method{summary}{mgNetwork}(object, ...)

\method{summary}{mgNetworksCollection}(object, ...)
}
\arguments{
\item{ids}{a vector of Mangal ID for networks (\code{numeric}).}

\item{as_sf}{a logical. Should networks metadata be converted into an sf object? Note that to use this feature \code{sf} must be installed.}

\item{force_collection}{a logical. Should the output to be of class  \code{mgNetworksCollection} even if it includes only one network.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{id}{a single ID network (\code{numeric}).}

\item{x}{an object of class \code{mgNetwork} or \code{mgNetworksCollection}.}

\item{...}{ignored.}

\item{object}{object of of class \code{mgNetwork} or \code{mgNetworksCollection}.}
}
\value{
A \code{mgNetwork} object includes five data frames:
\itemize{
\item network: includes all generic information on the network (if \code{as_sf=TRUE} then it is an object of class \code{sf});
\item nodes: information pertaining to nodes (includes taxonomic information);
\item interactions: includes ecological interactions and their attributes;
\item dataset: information pertaining to the original dataset;
\item reference: details about the original publication.
}

A summary method is available for objects of class \code{mgNetwork} object and returns the following network properties:
\itemize{
\item the number of nodes;
\item the number of edges;
\item the connectance;
\item the linkage density;
\item the degree (in, out an total) and the eigenvector centrality of every nodes.
}
}
\description{
Summarize mgNetwork properties.

Summarize mgNetworksCollection properties.
}
\section{Functions}{
\itemize{
\item \code{get_network_by_id_indiv}: Retrieve a network by its  collection of networks (default).
}}

\examples{
\donttest{
 net18 <- get_network_by_id(id = 18)
 net18_c <- get_network_by_id(id = 18, force_collection = TRUE)  
 nets <- get_network_by_id(id = c(18, 23))
}
}
