% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamer_presentation.R
\name{beamer_presentation}
\alias{beamer_presentation}
\title{Convert to a Beamer presentation}
\usage{
beamer_presentation(
  toc = FALSE,
  slide_level = NULL,
  number_sections = FALSE,
  incremental = FALSE,
  fig_width = 10,
  fig_height = 7,
  fig_crop = "auto",
  fig_caption = TRUE,
  dev = "pdf",
  df_print = "default",
  theme = "default",
  colortheme = "default",
  fonttheme = "default",
  highlight = "default",
  template = "default",
  keep_tex = FALSE,
  keep_md = FALSE,
  latex_engine = "pdflatex",
  citation_package = c("default", "natbib", "biblatex"),
  self_contained = TRUE,
  includes = NULL,
  md_extensions = NULL,
  pandoc_args = NULL
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output (only
level 1 headers will be included in the table of contents).}

\item{slide_level}{The heading level which defines individual slides. By
default this is the highest header level in the hierarchy that is followed
immediately by content, and not another header, somewhere in the document.
This default can be overridden by specifying an explicit
\code{slide_level}.}

\item{number_sections}{\code{TRUE} to number section headings}

\item{incremental}{\code{TRUE} to render slide bullets incrementally. Note
that if you want to reverse the default incremental behavior for an
individual bullet you can precede it with \code{>}. For example:
\emph{\code{> - Bullet Text}}}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_crop}{Whether to crop PDF figures with the command
\command{pdfcrop}. This requires the tools \command{pdfcrop} and
\command{ghostscript} to be installed. By default, \code{fig_crop = TRUE}
if these two tools are available.}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}. See
\href{https://bookdown.org/yihui/rmarkdown/html-document.html#data-frame-printing}{Data
frame printing section} in bookdown book for examples.}

\item{theme}{Beamer theme (e.g. "AnnArbor").}

\item{colortheme}{Beamer color theme (e.g. "dolphin").}

\item{fonttheme}{Beamer font theme (e.g. "structurebold").}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've
created.  See the documentation on
\href{https://pandoc.org/MANUAL.html}{pandoc online documentation} for
details on creating custom templates.}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{latex_engine}{LaTeX engine for producing PDF output. Options are
"pdflatex", "lualatex", "xelatex" and "tectonic".}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{default} if neither package is to be used,
which means citations will be processed via the command
\command{pandoc-citeproc}.}

\item{self_contained}{Whether to generate a full LaTeX document (\code{TRUE})
or just the body of a LaTeX document (\code{FALSE}). Note the LaTeX
document is an intermediate file unless \code{keep_tex = TRUE}.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to a Beamer presentation.
}
\details{
See the \href{https://bookdown.org/yihui/rmarkdown/beamer-presentation.html}{online
documentation} for additional details on using the \code{beamer_presentation}
format.

Creating Beamer output from R Markdown requires that LaTeX be installed.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{https://pandoc.org/MANUAL.html#citations}{Bibliographies
and Citations} article in the online documentation.
}
\examples{
\dontrun{

library(rmarkdown)

# simple invocation
render("pres.Rmd", beamer_presentation())

# specify an option for incremental rendering
render("pres.Rmd", beamer_presentation(incremental = TRUE))
}
}
