% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{pandoc_args}
\alias{pandoc_args}
\alias{pandoc_variable_arg}
\alias{pandoc_metadata_arg}
\alias{pandoc_include_args}
\alias{pandoc_highlight_args}
\alias{pandoc_latex_engine_args}
\alias{pandoc_toc_args}
\alias{pandoc_citeproc_args}
\alias{pandoc_lua_filter_args}
\title{Functions for generating pandoc command line arguments}
\usage{
pandoc_variable_arg(name, value)

pandoc_metadata_arg(name, value)

pandoc_include_args(in_header = NULL, before_body = NULL, after_body = NULL)

pandoc_highlight_args(highlight, default = "tango")

pandoc_latex_engine_args(latex_engine)

pandoc_toc_args(toc, toc_depth = 3)

pandoc_citeproc_args()

pandoc_lua_filter_args(lua_files)
}
\arguments{
\item{name}{Name of template variable to set.}

\item{value}{Value of template variable (defaults to \code{true} if missing).}

\item{in_header}{One or more files with content to be included in the
header of the document.}

\item{before_body}{One or more files with content to be included before
the document body.}

\item{after_body}{One or more files with content to be included after the
document body.}

\item{highlight}{The name of a pandoc syntax highlighting theme.}

\item{default}{The highlighting theme to use if "default"
is specified.}

\item{latex_engine}{LaTeX engine for producing PDF output. Options are
"pdflatex", "lualatex", "xelatex", and "tectonic".}

\item{toc}{\code{TRUE} to include a table of contents in the output.}

\item{toc_depth}{Depth of headers to include in table of contents.}

\item{lua_files}{Character vector of file paths to Lua filter files. Paths
will be transformed by \code{\link{pandoc_path_arg}}.}
}
\value{
A character vector with pandoc command line arguments.
}
\description{
Functions that assist in creating various types of pandoc command line
arguments (e.g. for templates, table of contents, highlighting, and content
includes).
}
\details{
Non-absolute paths for resources referenced from the
\code{in_header}, \code{before_body}, and \code{after_body}
parameters are resolved relative to the directory of the input document.
}
\section{About Pandoc citeproc}{

For Pandoc version before 2.11, a pandoc filter \samp{pandoc-citeproc} is
used. Since Pandoc 2.11, the feature is built-in and activated using
\samp{--citeproc} flag. \samp{pandoc_citeproc_arg} will return the correct
switches depending on the Pandoc version in use.
}

\examples{
\dontrun{
library(rmarkdown)

pandoc_include_args(before_body = "header.htm")
pandoc_include_args(before_body = "header.tex")

pandoc_highlight_args("kate")

pandoc_latex_engine_args("pdflatex")

pandoc_toc_args(toc = TRUE, toc_depth = 2)
}
}
