% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_format.R
\name{output_format_dependency}
\alias{output_format_dependency}
\title{Define an R Markdown's output format dependency}
\usage{
output_format_dependency(
  name,
  pandoc = list(),
  pre_processor = NULL,
  post_processor = NULL,
  file_scope = NULL,
  on_exit = NULL
)
}
\arguments{
\item{name}{A dependency name. If some dependencies share the same name,
then only the first one will be attached.}

\item{pandoc}{Pandoc options for an output format (see
\code{\link{pandoc_options}})}

\item{pre_processor}{An optional pre-processor function that receives the
\code{metadata}, \code{input_file}, \code{runtime}, \code{knit_meta},
\code{files_dir}, and \code{output_dir} and can return additional arguments
to pass to pandoc.}

\item{post_processor}{An optional post-processor function that receives the
\code{metadata}, \code{input_file}, \code{output_file}, \code{clean}, and
\code{verbose} parameters, and can return an alternative
\code{output_file}.}

\item{file_scope}{A function that will split markdown input to pandoc into
multiple named files. This is useful when the caller has concatenated a set
of Rmd files together (as \pkg{bookdown} does), and those files may need to
processed by pandoc using the \code{--file-scope} option. The first
argument is input file paths and the second is \code{NULL} or current file
scope which is a named list of files w/ \code{name} and \code{content} for
each file. The return is the new file scope. Also, the arguments should
include \code{...} for the future extensions.}

\item{on_exit}{A function to call when \code{rmarkdown::render()} finishes
execution (as registered with a \code{\link{on.exit}} handler).}
}
\value{
An list of arguments with the "rmd_dependency" class.
}
\description{
Define the dependency such as and pre/post-processors dynamically from
within chunks. This function shares some arguments with
\code{\link{output_format}}, but lacks the others because dependency
is resolved after \code{post_knit} and before \code{pre_processor}.
}
\examples{
# Add lua filters from within a chunk
output_format_dependency("lua_filter", pre_processor = function(...) {
  pandoc_lua_filter_args(c("example1.lua", "example2.lua"))
})

}
