% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_vignette.R
\name{html_vignette}
\alias{html_vignette}
\title{Convert to an HTML vignette}
\usage{
html_vignette(
  fig_width = 3,
  fig_height = 3,
  dev = "png",
  df_print = "default",
  css = NULL,
  keep_md = FALSE,
  readme = FALSE,
  self_contained = TRUE,
  ...
)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}.}

\item{css}{One or more css files to include}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{readme}{Use this vignette as the package README.md file (i.e. render
it as README.md to the package root). Note that if there are image files
within your vignette you should be sure to add README_files to .Rbuildignore}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{...}{Additional arguments passed to \code{\link{html_document}}. Please
note that \code{theme}, \code{fig_retina} and \code{highlight} are hard
coded. Setting any of those will yield an error.}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
A HTML vignette is a lightweight alternative to \code{\link{html_document}}
suitable for inclusion in packages to be released to CRAN. It reduces the
size of a basic vignette from 100k to around 10k.
}
\details{
Compared to \code{html_document}, it:

\itemize{
  \item never uses retina figures
  \item never uses a theme
  \item has a smaller default figure size
  \item uses a custom css stylesheet
  \item uses a custom highlight scheme
 }

See the \href{https://bookdown.org/yihui/rmarkdown/r-package-vignette.html}{online
documentation} for additional details on using the \code{html_vignette} format.
}
