/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.util.Enumeration;
import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class TwoWayNominalSplit
extends Splitter {
    private static final long serialVersionUID = -4598366190152721355L;
    private int attIndex;
    private int trueSplitValue;
    private PredictionNode[] children;

    public TwoWayNominalSplit(int _attIndex, int _trueSplitValue) {
        this.attIndex = _attIndex;
        this.trueSplitValue = _trueSplitValue;
        this.children = new PredictionNode[2];
    }

    @Override
    public int getNumOfBranches() {
        return 2;
    }

    @Override
    public int branchInstanceGoesDown(Instance inst) {
        if (inst.isMissing(this.attIndex)) {
            return -1;
        }
        if (inst.value(this.attIndex) == (double)this.trueSplitValue) {
            return 0;
        }
        return 1;
    }

    @Override
    public ReferenceInstances instancesDownBranch(int branch, Instances instances) {
        ReferenceInstances filteredInstances = new ReferenceInstances(instances, 1);
        if (branch == -1) {
            Enumeration e = instances.enumerateInstances();
            while (e.hasMoreElements()) {
                Instance inst = (Instance)e.nextElement();
                if (!inst.isMissing(this.attIndex)) continue;
                filteredInstances.addReference(inst);
            }
        } else if (branch == 0) {
            Enumeration e = instances.enumerateInstances();
            while (e.hasMoreElements()) {
                Instance inst = (Instance)e.nextElement();
                if (inst.isMissing(this.attIndex) || inst.value(this.attIndex) != (double)this.trueSplitValue) continue;
                filteredInstances.addReference(inst);
            }
        } else {
            Enumeration e = instances.enumerateInstances();
            while (e.hasMoreElements()) {
                Instance inst = (Instance)e.nextElement();
                if (inst.isMissing(this.attIndex) || inst.value(this.attIndex) == (double)this.trueSplitValue) continue;
                filteredInstances.addReference(inst);
            }
        }
        return filteredInstances;
    }

    @Override
    public String attributeString(Instances dataset) {
        return dataset.attribute(this.attIndex).name();
    }

    @Override
    public String comparisonString(int branchNum, Instances dataset) {
        Attribute att = dataset.attribute(this.attIndex);
        if (att.numValues() != 2) {
            return String.valueOf(branchNum == 0 ? "= " : "!= ") + att.value(this.trueSplitValue);
        }
        return "= " + (branchNum == 0 ? att.value(this.trueSplitValue) : att.value(this.trueSplitValue == 0 ? 1 : 0));
    }

    @Override
    public boolean equalTo(Splitter compare) {
        if (compare instanceof TwoWayNominalSplit) {
            TwoWayNominalSplit compareSame = (TwoWayNominalSplit)compare;
            return this.attIndex == compareSame.attIndex && this.trueSplitValue == compareSame.trueSplitValue;
        }
        return false;
    }

    @Override
    public void setChildForBranch(int branchNum, PredictionNode childPredictor) {
        this.children[branchNum] = childPredictor;
    }

    @Override
    public PredictionNode getChildForBranch(int branchNum) {
        return this.children[branchNum];
    }

    @Override
    public Object clone() {
        TwoWayNominalSplit clone = new TwoWayNominalSplit(this.attIndex, this.trueSplitValue);
        clone.orderAdded = this.orderAdded;
        if (this.children[0] != null) {
            clone.setChildForBranch(0, (PredictionNode)this.children[0].clone());
        }
        if (this.children[1] != null) {
            clone.setChildForBranch(1, (PredictionNode)this.children[1].clone());
        }
        return clone;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

