/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx;

import dmLab.array.FArray;
import dmLab.classifier.Params;
import dmLab.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public final class ADXParams
extends Params {
    public int searchBeam;
    private int[] finalBeam;
    public int complexGenerality;
    public int scoreMethod;
    public int scoreQ;
    public int qMethod;
    public int selSignificantMethod;
    public int qMethodFinal;
    public double qMin;
    public int useSensitivity;
    private double[] sensitivityArray;
    public boolean keepMinimalSet;
    public int mergeCondition;
    public int cleanCandidates;
    public int maxEventsForSelection;

    @Override
    public final boolean setDefault() {
        this.searchBeam = 1000;
        this.finalBeam = new int[1];
        this.finalBeam[0] = 50;
        this.complexGenerality = 0;
        this.scoreMethod = 5;
        this.scoreQ = 1;
        this.selSignificantMethod = 1;
        this.qMethod = 1;
        this.qMethodFinal = 2;
        this.qMin = 0.2;
        this.useSensitivity = 0;
        this.sensitivityArray = new double[1];
        this.sensitivityArray[0] = 1.0;
        this.keepMinimalSet = true;
        this.mergeCondition = 2;
        this.cleanCandidates = 2;
        this.maxEventsForSelection = 3000;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### ADX Parameters ### \n");
        tmp.append("adx.complexGenerality=" + this.complexGenerality).append('\n');
        tmp.append("adx.searchBeam=" + this.searchBeam).append('\n');
        tmp.append("adx.finalBeam=" + Arrays.toString(this.finalBeam)).append('\n');
        tmp.append("adx.qMethod=" + this.qMethod).append('\n');
        tmp.append("adx.qMethodFinal=" + this.qMethodFinal).append('\n');
        tmp.append("adx.qMin=" + this.qMin).append('\n');
        tmp.append("adx.selSignificantMethod=" + this.selSignificantMethod).append('\n');
        tmp.append("adx.scoreMethod=" + this.scoreMethod).append('\n');
        tmp.append("adx.scoreQ=" + this.scoreQ).append('\n');
        tmp.append("adx.useSensitivity=" + this.useSensitivity).append('\n');
        tmp.append("adx.sensitivityArray=" + Arrays.toString(this.sensitivityArray)).append('\n');
        tmp.append("adx.maxEventsForSelection=" + this.maxEventsForSelection).append('\n');
        tmp.append("adx.keepMinimalSet=" + this.keepMinimalSet).append('\n');
        tmp.append("adx.cleanCandidates=" + this.cleanCandidates).append('\n');
        tmp.append("adx.mergeCondition=" + this.mergeCondition).append('\n');
        tmp.append(super.toString());
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean update(Properties properties) {
        void var1_1;
        void var2_2;
        Object object;
        Object arrayStr;
        block4: {
            int n;
            this.searchBeam = Integer.valueOf(properties.getProperty("adx.searchBeam", "50"));
            arrayStr = properties.getProperty("adx.finalBeam", "[50]");
            arrayStr = ((String)arrayStr).substring(((String)arrayStr).indexOf(91) + 1, ((String)arrayStr).indexOf(93));
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (n2 < ((String)arrayStr).length()) {
                String string;
                n = ((String)arrayStr).indexOf(",", n2);
                if (n == -1) {
                    n = ((String)arrayStr).length();
                }
                if ((string = ((String)arrayStr).substring(n2, n).trim()).length() != 0) {
                    arrayList.add(string);
                    n2 = n + 1;
                    continue;
                }
                System.err.println("Array is empty");
                object = null;
                break block4;
            }
            arrayStr = new int[arrayList.size()];
            n = 0;
            while (n < ((Object)arrayStr).length) {
                arrayStr[n] = Integer.parseInt((String)arrayList.get(n));
                ++n;
            }
            object = arrayStr;
        }
        this.finalBeam = (int[])object;
        this.complexGenerality = Integer.valueOf(properties.getProperty("adx.complexGenerality", "0"));
        this.scoreMethod = Integer.valueOf(properties.getProperty("adx.scoreMethod", "6"));
        this.scoreQ = Integer.valueOf(properties.getProperty("adx.scoreQ", "1"));
        this.qMethod = Integer.valueOf(properties.getProperty("adx.qMethod", "1"));
        this.qMethodFinal = Integer.valueOf(properties.getProperty("adx.qMethodFinal", "2"));
        this.selSignificantMethod = Integer.valueOf(properties.getProperty("adx.selSignificantMethod", "4"));
        this.qMin = Double.valueOf(properties.getProperty("adx.qMin", "0.2"));
        this.useSensitivity = Integer.valueOf(properties.getProperty("adx.useSensitivity", "0"));
        arrayStr = properties.getProperty("adx.sensitivityArray", "[1]");
        arrayStr = ((String)arrayStr).substring(((String)arrayStr).indexOf(91) + 1, ((String)arrayStr).indexOf(93));
        this.sensitivityArray = ArrayUtils.toDoubleArray((String)var2_2);
        this.maxEventsForSelection = Integer.valueOf(properties.getProperty("adx.maxPosForSelection", "3000"));
        this.keepMinimalSet = Boolean.valueOf(properties.getProperty("adx.keepMinimalSet", "true"));
        this.cleanCandidates = Integer.valueOf(properties.getProperty("adx.cleanCandidates", "2"));
        this.mergeCondition = Integer.valueOf(var1_1.getProperty("adx.mergeCondition", "0"));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final double getSensitivity(int ruleSetIndex) {
        if (this.finalBeam.length > 1) {
            void var1_1;
            return this.sensitivityArray[var1_1];
        }
        return this.sensitivityArray[0];
    }

    /*
     * WARNING - void declaration
     */
    public final int getFinalBeam(int ruleSetIndex) {
        if (this.finalBeam.length > 1) {
            void var1_1;
            return this.finalBeam[var1_1];
        }
        return this.finalBeam[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean check(FArray array) {
        void var1_1;
        if (this.finalBeam.length == 1) {
            int val = this.finalBeam[0];
            this.finalBeam = new int[array.getDecValues().length];
            int i = 0;
            while (i < this.finalBeam.length) {
                this.finalBeam[i] = val;
                ++i;
            }
        }
        if (this.sensitivityArray.length == 1) {
            double val = this.sensitivityArray[0];
            this.sensitivityArray = new double[array.getDecValues().length];
            int i = 0;
            while (i < this.sensitivityArray.length) {
                this.sensitivityArray[i] = val;
                ++i;
            }
        }
        if (array.getDecValues().length != this.finalBeam.length) {
            System.err.println("Size of finalBeam array is different than decision values number!");
            return false;
        }
        int i = 0;
        while (i < this.finalBeam.length) {
            if (this.finalBeam[i] <= 0) {
                System.err.println("Size of finalBeam for value " + i + " is < 1!");
                return false;
            }
            ++i;
        }
        if (this.useSensitivity == 1 && this.sensitivityArray.length != 1 && var1_1.getDecValues().length != this.sensitivityArray.length) {
            System.err.println("Longest of sensitivityArray array is different than decision values number!");
            return false;
        }
        if (this.scoreMethod < 0 || this.scoreMethod > 7) {
            System.err.println("Incorrect scoreMethod.");
            return false;
        }
        if (this.qMethod < 0 || this.qMethod > 5) {
            System.err.println("Incorrect qMethod.");
            return false;
        }
        if (this.qMethodFinal < 0 || this.qMethodFinal > 5) {
            System.err.println("Incorrect qMethodFinal.");
            return false;
        }
        if (this.selSignificantMethod < 0 || this.selSignificantMethod > 4) {
            System.err.println("Incorrect selSignificantMethod.");
            return false;
        }
        if (this.cleanCandidates != 0 && this.cleanCandidates != 1 && this.cleanCandidates != 2) {
            System.err.println("Incorrect cleanCandidates.");
            return false;
        }
        if (this.mergeCondition != 0 && this.mergeCondition != 1 && this.mergeCondition != 2) {
            System.err.println("Incorrect mergeCondition.");
            return false;
        }
        if (this.maxEventsForSelection <= 0) {
            System.err.println("Incorrect maxPosForSelection. (maxPosForSelection<1)");
            return false;
        }
        i = 0;
        while (i < this.sensitivityArray.length) {
            if (this.sensitivityArray[i] > 1.0 || this.sensitivityArray[i] < 0.0) {
                System.err.println("Sensitivity must be between 0 and 1");
                return false;
            }
            ++i;
        }
        return true;
    }
}

