/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixLatex
extends ResultMatrix {
    private static final long serialVersionUID = 777690788447600978L;

    public ResultMatrixLatex() {
        this(1, 1);
    }

    public ResultMatrixLatex(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixLatex(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String getDisplayName() {
        return "LaTeX";
    }

    @Override
    public void clear() {
        super.clear();
        this.setPrintColNames(false);
        this.setEnumerateColNames(true);
        this.TIE_STRING = " ";
        this.WIN_STRING = "$\\circ$";
        this.LOSS_STRING = "$\\bullet$";
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        result.append("\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n");
        if (!this.getShowStdDev()) {
            result.append("\\footnotesize\n");
        } else {
            result.append("\\scriptsize\n");
        }
        if (!this.getShowStdDev()) {
            result.append("{\\centering \\begin{tabular}{lr");
        } else {
            result.append("{\\centering \\begin{tabular}{lr@{\\hspace{0cm}}c@{\\hspace{0cm}}r");
        }
        int j = 1;
        while (j < this.getColCount()) {
            if (!this.getColHidden(j)) {
                if (!this.getShowStdDev()) {
                    result.append("r@{\\hspace{0.1cm}}c");
                } else {
                    result.append("r@{\\hspace{0cm}}c@{\\hspace{0cm}}r@{\\hspace{0.1cm}}c");
                }
            }
            ++j;
        }
        result.append("}\n\\\\\n\\hline\n");
        if (!this.getShowStdDev()) {
            result.append("Dataset & " + cells[0][1]);
        } else {
            result.append("Dataset & \\multicolumn{3}{c}{" + cells[0][1] + "}");
        }
        j = 2;
        while (j < cells[0].length) {
            if (this.isMean(j)) {
                if (!this.getShowStdDev()) {
                    result.append("& " + cells[0][j] + " & ");
                } else {
                    result.append("& \\multicolumn{4}{c}{" + cells[0][j] + "} ");
                }
            }
            ++j;
        }
        result.append("\\\\\n\\hline\n");
        int i = 1;
        while (i < cells.length) {
            cells[i][0] = cells[i][0].replace('_', '-');
            ++i;
        }
        int n = 1;
        while (n < cells[0].length) {
            int size = this.getColSize(cells, n);
            i = 1;
            while (i < cells.length) {
                cells[i][n] = this.padString(cells[i][n], size, true);
                ++i;
            }
            ++n;
        }
        i = 1;
        while (i < cells.length - 1) {
            if (this.isAverage(i)) {
                result.append("\\hline\n");
            }
            n = 0;
            while (n < cells[0].length) {
                if (n == 0) {
                    result.append(this.padString(cells[i][n], this.getRowNameWidth()));
                } else {
                    if (this.getShowStdDev()) {
                        if (this.isMean(n - 1)) {
                            if (!cells[i][n].trim().equals("")) {
                                result.append(" & $\\pm$ & ");
                            } else {
                                result.append(" &       & ");
                            }
                        } else {
                            result.append(" & ");
                        }
                    } else {
                        result.append(" & ");
                    }
                    result.append(cells[i][n]);
                }
                ++n;
            }
            result.append("\\\\\n");
            ++i;
        }
        result.append("\\hline\n\\multicolumn{" + cells[0].length + "}{c}{$\\circ$, $\\bullet$" + " statistically significant improvement or degradation}" + "\\\\\n\\end{tabular} ");
        if (!this.getShowStdDev()) {
            result.append("\\footnotesize ");
        } else {
            result.append("\\scriptsize ");
        }
        result.append("\\par}\n\\end{table}\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption (Key)}\n";
        result = String.valueOf(result) + "\\scriptsize\n";
        result = String.valueOf(result) + "{\\centering\n";
        result = String.valueOf(result) + "\\begin{tabular}{cl}\\\\\n";
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                result = String.valueOf(result) + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + " & " + this.removeFilterName(this.m_ColNames[i]).replace('_', '-').replaceAll("\\\\", "\\\\textbackslash") + " \\\\\n";
            }
            ++i;
        }
        result = String.valueOf(result) + "\\end{tabular}\n";
        result = String.valueOf(result) + "}\n";
        result = String.valueOf(result) + "\\end{table}\n";
        return result;
    }

    @Override
    public String toStringSummary() {
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        String result = "";
        String titles = "";
        result = String.valueOf(result) + "{\\centering\n";
        result = String.valueOf(result) + "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n";
        result = String.valueOf(result) + "\\footnotesize\n";
        result = String.valueOf(result) + "\\begin{tabular}{l";
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                titles = String.valueOf(titles) + " &";
                result = String.valueOf(result) + "c";
                titles = String.valueOf(titles) + ' ' + Utils.padLeft(this.getSummaryTitle(i), resultsetLength * 2 + 3);
            }
            ++i;
        }
        result = String.valueOf(result) + "}\\\\\n\\hline\n";
        result = String.valueOf(result) + titles + " \\\\\n\\hline\n";
        i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                int j = 0;
                while (j < this.getColCount()) {
                    if (!this.getColHidden(j)) {
                        if (j == 0) {
                            result = String.valueOf(result) + (char)(97 + i % 26);
                        }
                        result = j == i ? String.valueOf(result) + " & - " : String.valueOf(result) + "& " + this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ") ";
                    }
                    ++j;
                }
                result = String.valueOf(result) + "\\\\\n";
            }
            ++i;
        }
        result = String.valueOf(result) + "\\hline\n\\end{tabular} \\footnotesize \\par\n\\end{table}}";
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n\\footnotesize\n{\\centering \\begin{tabular}{rlll}\\\\\n\\hline\n";
        result = String.valueOf(result) + "Resultset & Wins$-$ & Wins & Losses \\\\\n& Losses & & \\\\\n\\hline\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        int i = this.getColCount() - 1;
        while (i >= 0) {
            int curr = ranking[i];
            if (!this.getColHidden(curr)) {
                result = String.valueOf(result) + "(" + (curr + 1) + ") & " + Utils.padLeft("" + this.m_RankingDiff[curr], width) + " & " + Utils.padLeft("" + this.m_RankingWins[curr], width) + " & " + Utils.padLeft("" + this.m_RankingLosses[curr], width) + "\\\\\n";
            }
            --i;
        }
        result = String.valueOf(result) + "\\hline\n\\end{tabular} \\footnotesize \\par}\n\\end{table}";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] args) {
        ResultMatrixLatex matrix = new ResultMatrixLatex(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        int i = 0;
        while (i < matrix.getRowCount()) {
            int n = 0;
            while (n < matrix.getColCount()) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i == n) {
                    if (i % 2 == 1) {
                        matrix.setSignificance(n, i, 1);
                    } else {
                        matrix.setSignificance(n, i, 2);
                    }
                }
                ++n;
            }
            ++i;
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringHeader()) + "\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringMatrix()) + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

