/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.rng;

import jdistlib.rng.RandomEngine;

public class RandomCMWC
extends RandomEngine {
    private long[] mBuffer = new long[4096];
    private int mIndex = 4095;
    private boolean mHaveNextGaussian = false;
    private double mNextGaussian;

    public RandomCMWC() {
        this.mSeed = 362436L;
    }

    public final int nextInt() {
        this.mIndex = this.mIndex + 1 & 0xFFF;
        long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
        this.mSeed = t >> 32;
        long x = t + this.mSeed;
        if (x < this.mSeed) {
            ++x;
            ++this.mSeed;
        }
        this.mBuffer[this.mIndex] = -2L - x;
        return (int)this.mBuffer[this.mIndex];
    }

    public final int nextInt(int n) {
        int val;
        long x;
        int bits;
        if ((n & -n) == n) {
            this.mIndex = this.mIndex + 1 & 0xFFF;
            long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            long x2 = t + this.mSeed;
            if (x2 < this.mSeed) {
                ++x2;
                ++this.mSeed;
            }
            this.mBuffer[this.mIndex] = -2L - x2;
            return (int)((long)n * (this.mBuffer[this.mIndex] >>> 1) >> 31);
        }
        do {
            this.mIndex = this.mIndex + 1 & 0xFFF;
            long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x >= this.mSeed) continue;
            ++x;
            ++this.mSeed;
        } while ((bits = (int)((this.mBuffer[this.mIndex] = -2L - x) >>> 1)) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    public final long nextLong() {
        this.mIndex = this.mIndex + 1 & 0xFFF;
        long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
        this.mSeed = t >> 32;
        long x = t + this.mSeed;
        if (x < this.mSeed) {
            ++x;
            ++this.mSeed;
        }
        this.mBuffer[this.mIndex] = -2L - x;
        return this.mBuffer[this.mIndex];
    }

    public final long nextLong(long n) {
        long val;
        long x;
        long bits;
        if ((n & -n) == n) {
            this.mIndex = this.mIndex + 1 & 0xFFF;
            long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            long x2 = t + this.mSeed;
            if (x2 < this.mSeed) {
                ++x2;
                ++this.mSeed;
            }
            this.mBuffer[this.mIndex] = -2L - x2;
            return (int)(n * (this.mBuffer[this.mIndex] >>> 1) >> 31);
        }
        do {
            this.mIndex = this.mIndex + 1 & 0xFFF;
            long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x >= this.mSeed) continue;
            ++x;
            ++this.mSeed;
        } while ((bits = (this.mBuffer[this.mIndex] = -2L - x) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    public final double nextGaussian() {
        long x;
        int b;
        int a;
        double v2;
        int z;
        int y;
        double v1;
        double s;
        if (this.mHaveNextGaussian) {
            this.mHaveNextGaussian = false;
            return this.mNextGaussian;
        }
        do {
            this.mIndex = this.mIndex + 1 & 0xFFF;
            long t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x < this.mSeed) {
                ++x;
                ++this.mSeed;
            }
            this.mBuffer[this.mIndex] = -2L - x;
            y = (int)this.mBuffer[this.mIndex];
            this.mIndex = this.mIndex + 1 & 0xFFF;
            t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x < this.mSeed) {
                ++x;
                ++this.mSeed;
            }
            this.mBuffer[this.mIndex] = -2L - x;
            z = (int)this.mBuffer[this.mIndex];
            this.mIndex = this.mIndex + 1 & 0xFFF;
            t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x < this.mSeed) {
                ++x;
                ++this.mSeed;
            }
            this.mBuffer[this.mIndex] = -2L - x;
            a = (int)this.mBuffer[this.mIndex];
            this.mIndex = this.mIndex + 1 & 0xFFF;
            t = 18782L * this.mBuffer[this.mIndex] + this.mSeed;
            this.mSeed = t >> 32;
            x = t + this.mSeed;
            if (x >= this.mSeed) continue;
            ++x;
            ++this.mSeed;
        } while ((s = (v1 = 2.0 * ((double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = 2.0 * ((double)(((long)(a >>> 6) << 27) + (long)((b = (int)(this.mBuffer[this.mIndex] = -2L - x)) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.mHaveNextGaussian = true;
        this.mNextGaussian = v2 * multiplier;
        return v1 * multiplier;
    }

    public double nextDouble() {
        double nextDouble;
        while (!((nextDouble = ((double)this.nextLong() - -9.223372036854776E18) * 5.421010862427522E-20) > 0.0) || !(nextDouble < 1.0)) {
        }
        return nextDouble;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public RandomCMWC clone() {
        return new RandomCMWC();
    }
}

