/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.File2Array;
import dmLab.classifier.Params;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.cutoffMethods.Cutoff;
import dmLab.mcfs.mcfsEngine.MCFSAutoParams;
import dmLab.mcfs.mcfsEngine.arrays.MCFSArrays;
import dmLab.mcfs.mcfsEngine.framework.GlobalStats;
import dmLab.mcfs.mcfsEngine.framework.MCFSJob;
import dmLab.utils.ArrayUtils;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.condition.Condition;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public abstract class MCFSFramework
implements Runnable {
    protected MCFSParams mcfsParams;
    public MCFSArrays mcfsArrays;
    public GlobalStats globalStats;
    public String chartTitle;
    public String experimentName;
    protected Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSFramework(Random random) {
        void var1_1;
        this.random = var1_1;
        this.experimentName = "";
        this.chartTitle = "MCFS-ID Progress";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean run(MCFSParams mcfsParams) {
        void var1_1;
        FArray inputArray;
        Object object;
        Object object2;
        Object object3;
        this.mcfsParams = mcfsParams.clone();
        Object object4 = this;
        if (((MCFSFramework)object4).mcfsArrays == null) {
            ((MCFSFramework)object4).mcfsArrays = new MCFSArrays();
            object3 = ((MCFSFramework)object4).mcfsParams;
            object2 = ((MCFSFramework)object4).mcfsArrays;
            ((MCFSFramework)object4).mcfsArrays.sourceArray = new FArray();
            File2Array file2Array = new File2Array();
            object = new File(String.valueOf(((MCFSParams)object3).inputFilesPATH) + "//" + ((MCFSParams)object3).inputFileName);
            if (!file2Array.load(((MCFSArrays)object2).sourceArray, ((File)object).getAbsolutePath())) {
                return false;
            }
            if (!((MCFSArrays)object2).sourceArray.checkDecisionValues()) {
                return false;
            }
            object4 = object2;
            if (((MCFSArrays)object4).sourceArray != null) {
                ((MCFSArrays)object4).sourceArray.findDomains();
                ((MCFSArrays)object4).sourceArray.fixAttributesNames$1385ff();
            }
            boolean bl = true;
            if (!bl) {
                return false;
            }
        }
        boolean bl = true;
        if (!bl) {
            return false;
        }
        if (this.experimentName.isEmpty()) {
            this.experimentName = mcfsParams.getExperimentName();
        }
        FArray fArray = inputArray = this.mcfsArrays.sourceArray;
        object2 = fArray.attributes[var1_1.getDecAttrIdx()].name;
        object4 = fArray;
        boolean[] blArray = DiscFunctions.getRowMask(fArray, new Condition(String.valueOf(object2) + " != ?"));
        object3 = blArray;
        int n = ArrayUtils.count(blArray, false);
        if (n > 0) {
            System.out.print("Warning! Target column contains '?' values...");
            boolean[] blArray2 = new boolean[((Array)object4).colsNumber()];
            object = blArray2;
            Arrays.fill(blArray2, true);
            object4 = ((Array)object4).clone((boolean[])object, (boolean[])object3);
            ((Array)object4).findDomains();
            ((Array)object4).setAllDecValues();
            System.out.println(" " + n + " rows are removed.");
        }
        this.mcfsArrays.sourceArray = (FArray)object4;
        this.run();
        return true;
    }

    @Override
    public abstract void run();

    /*
     * WARNING - void declaration
     */
    protected final ConfusionMatrix runExperiment(FArray inputArray) {
        if (this.mcfsParams.verbose) {
            System.out.println("MCFSFramework.runExperiment() Running experiment: " + this.experimentName);
        }
        if (!this.mcfsParams.check(inputArray)) {
            return null;
        }
        if (this.mcfsParams.verbose) {
            System.out.println("MCFSFramework Params: \n" + this.mcfsParams.toString());
        }
        if (!inputArray.isTargetNominal()) {
            this.mcfsParams.balance = 0.0f;
            this.mcfsParams.finalRuleset = false;
        }
        if (this.mcfsParams.buildID) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.buildID ? 1 : 0, "ID-Graph"));
        }
        if (this.mcfsParams.finalCV) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.finalCV ? 1 : 0, "finalCV"));
        }
        if (this.mcfsParams.finalRuleset) {
            System.out.println("MCFS-ID param: " + Params.intParamToString(this.mcfsParams.finalRuleset ? 1 : 0, "finalRuleset"));
        }
        if (this.mcfsParams.balance != 0.0f) {
            System.out.println("MCFS-ID param: " + Params.intParamToString((int)this.mcfsParams.balance, "balance classes"));
        }
        this.mcfsParams.balancedClassSizes = MCFSAutoParams.getBalancedClassSizes(this.mcfsParams, inputArray);
        this.mcfsParams.splitSetClassSizes = MCFSAutoParams.getSplitSetClassSizes(this.mcfsParams, inputArray);
        if (this.mcfsParams.cutoffMethod.equalsIgnoreCase("contrast")) {
            System.out.println("Adding Contrast Attributes...");
            FArray fArray = inputArray;
            int contrastColumns22 = Math.max(Math.round(((float)fArray.attributes.length - 1.0f) * this.mcfsParams.contrastSize), MCFSParams.CONTRAST_ATTR_MIN);
            DiscFunctions.addColumnsUniform(inputArray, MCFSParams.CONTRAST_ATTR_NAME, contrastColumns22);
            FArray contrastColumns22 = inputArray;
            System.out.println("Data size: attributes: " + contrastColumns22.attributes.length + " objects: " + inputArray.rowsNumber());
        }
        this.globalStats = new GlobalStats();
        this.globalStats.init$660d8861(inputArray, this.mcfsParams, this.chartTitle);
        inputArray.calcDecisionValuesTable();
        Cutoff cutoff = new Cutoff(this.mcfsParams);
        this.globalStats.setCutoff(cutoff);
        int threadsNumber = this.mcfsParams.threadsNumber;
        System.out.println("Starting MCFS-ID Procedure: projectionSize(m) = " + this.mcfsParams.projectionSizeValue + ", projections(s) = " + this.mcfsParams.projectionsValue + ", splits(t) = " + this.mcfsParams.splits);
        long start = System.currentTimeMillis();
        System.out.println("Start time: " + new Date(start).toString());
        MCFSJob[] mcfsJob = new MCFSJob[threadsNumber];
        Thread[] jobs = new Thread[threadsNumber];
        int i = 0;
        while (i < threadsNumber) {
            mcfsJob[i] = new MCFSJob(i, this.mcfsParams, inputArray, this.globalStats);
            mcfsJob[i].init(new Random(this.random.nextLong()));
            jobs[i] = new Thread(mcfsJob[i]);
            jobs[i].setPriority(8);
            ++i;
        }
        System.out.println("Running: " + threadsNumber + " threads...");
        this.globalStats.initTextProgressBar();
        i = 0;
        while (i < jobs.length) {
            jobs[i].start();
            ++i;
        }
        try {
            i = 0;
            while (i < jobs.length) {
                jobs[i].join();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedException i2 = interruptedException;
            interruptedException.printStackTrace();
        }
        int i3 = 0;
        while (i3 < threadsNumber) {
            mcfsJob[i3].finish();
            ++i3;
        }
        this.globalStats.finalizeImportances();
        ConfusionMatrix confusionMatrix = this.globalStats.getConfusionMatrix();
        this.globalStats.finalizeTextProgressBar();
        long l = System.currentTimeMillis();
        float experimentTime = (float)(l - start) / 1000.0f;
        System.out.println(String.valueOf(this.mcfsParams.projectionsValue * this.mcfsParams.splits) + " trees built within " + DiscFunctions.timeIntervalFormat(experimentTime));
        System.out.println();
        if (confusionMatrix != null) {
            System.out.println("Prediction Summary on a Random Subsample (st):");
            System.out.println(confusionMatrix.statsToString(2, false));
        } else {
            System.out.println("Prediction Summary on a Random Subsample (st):");
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("pearson"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("MAE"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("RMSE"));
            System.out.println(this.globalStats.getSplitsStats().toStringSummary("SMAPE"));
            System.out.println();
        }
        double minRI = cutoff.calcCutoff(this.globalStats.getAttrImportances()[0]);
        System.out.println("Cutoff RI (based on mean cutoff value) = " + DiscFunctions.formatFloat(minRI, 7));
        int mainMeasureIndex = this.globalStats.getAttrImportances()[0].mainMeasureIdx;
        Ranking topRanking = this.globalStats.getAttrImportances()[0].getTopRanking(mainMeasureIndex, (float)minRI);
        if (topRanking != null) {
            System.out.println("Important attributes (based on mean cutoff value) = " + topRanking.size());
        }
        if (this.mcfsParams.saveResultFiles) {
            void var2_7;
            if (this.mcfsParams.verbose) {
                System.out.println("Saving results files for experiment: " + this.experimentName);
            }
            AttributesRI[] attrRI = this.globalStats.getAttrImportances();
            int j = 0;
            while (j < attrRI.length) {
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + attrRI[j].label + "_" + this.mcfsParams.filesufix_RI, attrRI[j].toString());
                ++j;
            }
            if (this.globalStats.getAttrConnections() != null) {
                this.globalStats.getAttrConnections().save(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_ID);
            }
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, var2_7.toString());
            if (topRanking != null) {
                void var1_4;
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, var1_4.toString());
            }
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_DISTANCE, this.globalStats.getDistances().toString());
            if (confusionMatrix != null) {
                String matrix = confusionMatrix.toString(false, true, false, ",");
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_MATRIX, matrix);
            } else {
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + "_" + MCFSParams.FILESUFIX_PREDICTION_STATS, this.globalStats.getSplitsStats().toString());
            }
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + this.experimentName + ".run", this.mcfsParams.toString());
        }
        this.cleanTmpWekaFiles();
        this.globalStats.closeChartFrame();
        return confusionMatrix;
    }

    /*
     * WARNING - void declaration
     */
    private void cleanTmpWekaFiles() {
        int i = 0;
        while (i < this.mcfsParams.threadsNumber) {
            void var3_3;
            void var2_2;
            File trainFile = new File(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + "C" + i + "_tmp_train.arff");
            File testFile = new File(String.valueOf(this.mcfsParams.resFilesPATH) + File.separator + "C" + i + "_tmp_test.arff");
            DiscFunctions.deleteFile(var2_2.getAbsolutePath());
            DiscFunctions.deleteFile(var3_3.getAbsolutePath());
            ++i;
        }
    }
}

