% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Let}
\alias{Let}
\title{Let}
\description{
Create let expression in MiniZinc
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Let}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.decl}}{list of local declarations}

\item{\code{.in}}{body of the let}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.decl}}{list of local declarations}

\item{\code{.in}}{body of the let}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Let$new()}}
\item \href{#method-getLets}{\code{Let$getLets()}}
\item \href{#method-setLets}{\code{Let$setLets()}}
\item \href{#method-getLet}{\code{Let$getLet()}}
\item \href{#method-setLet}{\code{Let$setLet()}}
\item \href{#method-getBody}{\code{Let$getBody()}}
\item \href{#method-setBody}{\code{Let$setBody()}}
\item \href{#method-c_str}{\code{Let$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Let$getDeleteFlag()}}
\item \href{#method-delete}{\code{Let$delete()}}
\item \href{#method-clone}{\code{Let$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$new(let, body)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{let}}{list of local declarations}

\item{\code{body}}{body of the let}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLets"></a>}}
\if{latex}{\out{\hypertarget{method-getLets}{}}}
\subsection{Method \code{getLets()}}{
access list of local declarations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$getLets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setLets"></a>}}
\if{latex}{\out{\hypertarget{method-setLets}{}}}
\subsection{Method \code{setLets()}}{
set list of local declarations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$setLets(letList)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{letList}}{list of declarations to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLet"></a>}}
\if{latex}{\out{\hypertarget{method-getLet}{}}}
\subsection{Method \code{getLet()}}{
access local declaration i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$getLet(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index of let declaration to be accessed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setLet"></a>}}
\if{latex}{\out{\hypertarget{method-setLet}{}}}
\subsection{Method \code{setLet()}}{
set list of local declarations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$setLet(let)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{let}}{declaration to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBody"></a>}}
\if{latex}{\out{\hypertarget{method-getBody}{}}}
\subsection{Method \code{getBody()}}{
get the body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$getBody()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setBody"></a>}}
\if{latex}{\out{\hypertarget{method-setBody}{}}}
\subsection{Method \code{setBody()}}{
set the body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$setBody(expBody)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expBody}}{expression to be set for body}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Let$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
