% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_reference_points.R
\name{generate_reference_points}
\alias{generate_reference_points}
\title{Determination of Reference Points on a Hyper-Plane}
\usage{
generate_reference_points(m, h)
}
\arguments{
\item{m, h}{Number of reference points 'h' in M-objective problems}
}
\value{
A matrix with the reference points uniformly distributed.
}
\description{
A implementation of Das and Dennis's Reference Points Generation.
}
\details{
The implemented Reference Point Generation is based on the Das and Dennis's
systematic approach that places points on a normalized hyper-plane which is
equally inclined to all objective axes and has an intercept of one on each axis.
}
\references{
K. Deb and H. Jain, 'An Evolutionary Many-Objective Optimization
Algorithm Using Reference-Point-Based Nondominated Sorting Approach, Part I:
Solving Problems With Box Constraints,' in IEEE Transactions on Evolutionary
Computation, vol. 18, no. 4, pp. 577-601, Aug. 2014,
doi: 10.1109/TEVC.2013.2281535.

Das, Indraneel & Dennis, J. (2000). Normal-Boundary Intersection: A New
Method for Generating the Pareto Surface in Nonlinear Multicriteria
Optimization Problems. SIAM Journal on Optimization. 8.
10.1137/S1052623496307510.
}
\seealso{
\code{\link[=non_dominated_fronts]{non_dominated_fronts()}} and \code{\link[=get_fixed_rowsum_integer_matrix]{get_fixed_rowsum_integer_matrix()}}
}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
