% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_coastline.R
\name{ne_coastline}
\alias{ne_coastline}
\title{Get natural earth world coastline}
\usage{
ne_coastline(scale = 110, returnclass = c("sp", "sf"))
}
\arguments{
\item{scale}{scale of map to return, one of \code{110}, \code{50}, \code{10}
or \code{'small'}, \code{'medium'}, \code{'large'}}

\item{returnclass}{'sp' default or 'sf' for Simple Features}
}
\value{
\code{SpatialLinesDataFrame} or \code{sf}
}
\description{
returns world coastline at specified scale
}
\examples{
if (requireNamespace("rnaturalearthdata")) {
  sldf_coast <- ne_coastline()

  if (require(sp)) {
    plot(sldf_coast)
  }
}

}
