% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.UME_function.R
\name{run_ume}
\alias{run_ume}
\title{Perform the unrelated mean effects model}
\usage{
run_ume(full, n_iter, n_burnin, n_chains, n_thin)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_chains}{Positive integer specifying the number of chains for the MCMC
sampling; an argument of the \code{\link[R2jags:jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_thin}{Positive integer specifying the thinning rate for the MCMC
sampling; an argument of the \code{\link[R2jags:jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
An R2jags output on the summaries of the posterior distribution, and
  the Gelman-Rubin convergence diagnostic (Gelman et al., 1992) of the
  following monitored parameters:
  \item{EM}{The summary effect estimate (according to the argument
  \code{measure} defined in \code{\link{run_model}}) for each pairwise
  comparison observed in the network.}
  \item{dev_o}{The deviance contribution of each trial-arm based on the
  observed outcome.}
  \item{hat_par}{The fitted outcome at each trial-arm.}
  \item{tau}{The between-trial standard deviation (assumed common across the
  observed pairwise comparisons) for the whole network, when a random-effects
  model has been specified.}
  \item{m_tau}{The between-trial standard deviation (assumed common
  across the observed pairwise comparisons) for the subset of multi-arm
  trials, when a random-effects model has been specified.}

  The output also includes the following elements:
  \item{leverage_o}{The leverage for the observed outcome at each trial-arm.}
  \item{sign_dev_o}{The sign of the difference between observed and fitted
  outcome at each trial-arm.}
  \item{model_assessment}{A data-frame on the measures of model assessment:
  deviance information criterion, number of effective parameters, and total
  residual deviance.}
  \item{jagsfit}{An object of S3 class \code{\link[R2jags:jags]{jags}} with
  the posterior results on all monitored parameters to be used in the
  \code{\link{mcmc_diagnostics}} function.}

  Furthermore, \code{run_ume} returns a character vector with the pairwise
  comparisons observed in the network, \code{obs_comp}, and a character
  vector with comparisons between the non-baseline interventions observed in
  multi-arm trials only, \code{frail_comp}. Both vectors are used in
  \code{\link{ume_plot}} function.
}
\description{
Performs the unrelated mean effects model of Dias et al. (2013)
  that has been refined (Spineli, 2021) and extended to address aggregate
  binary and continuous missing participant outcome data via the
  pattern-mixture model (Spineli et al. 2021; Spineli, 2019). This model
  offers a global evaluation of the plausibility of the consistency
  assumption in the network.
}
\details{
\code{run_ume} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{heter_prior},
  \code{mean_misspar}, \code{var_misspar}, and \code{ref} from
  \code{\link{run_model}}.
  This prevents specifying a different Bayesian model from that considered in
  \code{\link{run_model}}.Therefore, the user needs first to apply
  \code{\link{run_model}}, and then use \code{run_ume} (see 'Examples').

  The \code{run_ume} function also returns the arguments \code{data},
  \code{model}, \code{measure}, \code{assumption}, \code{n_chains},
  \code{n_iter}, \code{n_burnin}, and \code{n_thin} as specified by the user
  to be inherited by other relevant functions of the package.

  Initially, \code{run_ume} calls the \code{\link{improved_ume}} function to
  identify the \emph{frail comparisons}, that is, comparisons between
  non-baseline interventions in multi-arm trials not investigated in any
  two-arm or multi-arm trial of the network (Spineli, 2021). The 'original'
  model of Dias et al. (2013) omits the frail comparisons from the estimation
  process. Consequently, the number of estimated summary effects is less
  than those obtained by performing separate pairwise meta-analyses
  (see \code{\link{run_series_meta}}).

  For a binary outcome, when \code{measure} is "RR" (relative risk) or "RD"
  (risk difference) in \code{\link{run_model}}, \code{run_ume} currently
  considers the odds ratio as effect measure for being the \strong{base-case}
  effect measure in \code{\link{run_model}} for a binary outcome
  (see also 'Details' in \code{\link{run_model}}).

  \code{run_ume} calls the \code{\link{prepare_ume}} function which contains
  the WinBUGS code as written by Dias et al. (2013) for binomial and normal
  likelihood to analyse binary and continuous outcome data, respectively.
  \code{\link{prepare_ume}} has been extended to incorporate the
  pattern-mixture model with informative missingness parameters for binary
  and continuous outcome data (see 'Details' in \code{\link{run_model}}).
  \code{\link{prepare_ume}} has also been refined to account for the
  multi-arm trials by assigning conditional univariate normal distributions
  on the underlying trial-specific effect size of comparisons with the
  baseline arm of the multi-arm trial (Spineli, 2021).

  \code{run_ume} runs Bayesian unrelated mean effects model in \code{JAGS}.
  The progress of the simulation appears on the R console.

  The output of \code{run_ume} is not end-user-ready. The
  \code{\link{ume_plot}} function uses the output of \code{run_ume} as an S3
  object and processes it further to provide an end-user-ready output.

  \code{run_ume} can be used only for a network of interventions. In the case
  of two interventions, the execution of the function will be stopped and an
  error message will be printed on the R console.
}
\examples{
data("nma.liu2013")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_liu.rds', package = 'rnmamod'))

\donttest{
# Run random-effects unrelated mean effects model
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_ume(full = res,
        n_chains = 3,
        n_iter = 1000,
        n_burnin = 100,
        n_thin = 1)
}

}
\references{
Dias S, Welton NJ, Sutton AJ, Caldwell DM, Lu G, Ades AE. Evidence synthesis
for decision making 4: inconsistency in networks of evidence based on
randomized controlled trials.
\emph{Med Decis Making} 2013;\bold{33}(5):641--56.
doi: 10.1177/0272989X12455847

Gelman A, Rubin DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136

Spineli LM. A Revised Framework to Evaluate the Consistency Assumption
Globally in a Network of Interventions. \emph{Med Decis Making} 2021.
doi: 10.1177/0272989X211068005

Spineli LM, Kalyvas C, Papadimitropoulou K. Continuous(ly) missing outcome
data in network meta-analysis: a one-stage pattern-mixture model approach.
\emph{Stat Methods Med Res} 2021;\bold{30}(4):958--75.
doi: 10.1177/0962280220983544

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
doi: 10.1186/s12874-019-0731-y
}
\seealso{
\code{\link[R2jags:jags]{jags}},
  \code{\link{prepare_ume}}, \code{\link{run_model}},
  \code{\link{run_series_meta}}, \code{\link{ume_plot}}
}
\author{
{Loukia M. Spineli}
}
