\name{noaa_stations}
\alias{noaa_stations}
\title{Get metadata about NOAA stations.}
\usage{
noaa_stations(stationid = NULL, datasetid = NULL, datatypeid = NULL,
  locationid = NULL, startdate = NULL, enddate = NULL, sortfield = NULL,
  sortorder = NULL, limit = 25, offset = NULL, datacategoryid = NULL,
  extent = NULL, token = getOption("noaakey",
  stop("you need an API key NOAA data")), callopts = list(), dataset = NULL,
  station = NULL, location = NULL, locationtype = NULL, page = NULL)
}
\arguments{
  \item{datasetid}{Accepts a single valid dataset id. Data
  returned will be from the dataset specified, see
  datasets() (required)}

  \item{datatypeid}{Accepts a valid data type id or a chain
  of data type ids in a comma-separated vector. Data
  returned will contain all of the data type(s) specified
  (optional)}

  \item{locationid}{Accepts a valid location id or a chain
  of location ids in a comma-separated vector. Data
  returned will contain data for the location(s) specified
  (optional)}

  \item{stationid}{Accepts a valid station id or a chain of
  of station ids in a comma-separated vector. Data returned
  will contain data for the station(s) specified
  (optional)}

  \item{startdate}{Accepts valid ISO formated date
  (yyyy-mm-dd). Data returned will have data after the
  specified date. Paramater can be use independently of
  enddate (optional)}

  \item{enddate}{Accepts valid ISO formated date
  (yyyy-mm-dd). Data returned will have data before the
  specified date. Paramater can be use independently of
  startdate (optional)}

  \item{sortfield}{The field to sort results by. Supports
  id, name, mindate, maxdate, and datacoverage fields
  (optional)}

  \item{sortorder}{Which order to sort by, asc or desc.
  Defaults to asc (optional)}

  \item{limit}{Defaults to 25, limits the number of results
  in the response. Maximum is 1000 (optional)}

  \item{offset}{Defaults to 0, used to offset the
  resultlist (optional)}

  \item{token}{This must be a valid token token supplied to
  you by NCDC's Climate Data Online access token generator.
  (required) Get an API key (=token) at
  \url{http://www.ncdc.noaa.gov/cdo-web/token}. You can
  pass your token in as an argument or store it in your
  .Rprofile file with an entry like \itemize{ \item
  options("noaakey" = "your-noaa-token") }}

  \item{callopts}{Further arguments passed on to the API
  GET call. (optional)}

  \item{datacategoryid}{Accepts a valid data category id or
  an array of data category ids.  Stations returned will be
  associated with the data category(ies) specified
  (optional)}

  \item{extent}{The geographical extent for which you want
  to search. Designed to take a parameter generated by
  Google Maps API V3 LatLngBounds.toUrlValue. Stations
  returned must be located within the extent specified
  (optional)}

  \item{dataset}{THIS IS A DEPRECATED ARGUMENT. See
  datasetid.}

  \item{station}{THIS IS A DEPRECATED ARGUMENT. See
  stationid.}

  \item{location}{THIS IS A DEPRECATED ARGUMENT. See
  locationid.}

  \item{locationtype}{THIS IS A DEPRECATED ARGUMENT. There
  is no equivalent argument in v2 of the NOAA API.}

  \item{page}{THIS IS A DEPRECATED ARGUMENT. There is no
  equivalent argument in v2 of the NOAA API.}
}
\description{
From the NOAA API docs: Stations are where the data comes
from (for most datasets) and can be considered the smallest
granual of location data. If you know what station you
want, you can quickly get all manner of data from it
}
\examples{
\dontrun{
# Get metadata on all stations
noaa_stations()
noaa_stations(limit=5)

# Get metadata on a single station
noaa_stations(stationid='COOP:010008')

# Displays all stations within GHCN-Daily (100 Stations per page limit)
noaa_stations(datasetid='GHCND')

# Station
noaa_stations(datasetid='NORMAL_DLY', stationid='GHCND:USW00014895')

# Displays all stations within GHCN-Daily (Displaying page 10 of the results)
noaa_stations(datasetid='GHCND')

# Specify datasetid and locationid
noaa_stations(datasetid='GHCND', locationid='FIPS:12017')

# Specify datasetid, locationid, and station
noaa_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Specify datasetid, locationidtype, locationid, and station
noaa_stations(datasetid='GHCND', locationid='FIPS:12017', stationid='GHCND:USC00084289')

# Displays list of stations within the specified county
noaa_stations(datasetid='GHCND', locationid='FIPS:12017')

# Displays list of Hourly Precipitation locationids between 01/01/1990 and 12/31/1990
noaa_stations(datasetid='PRECIP_HLY', startdate='19900101', enddate='19901231')
}
}

