% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghcnd.R
\name{ghcnd_search}
\alias{ghcnd_search}
\title{Get a cleaned version of GHCND data from a single weather site}
\usage{
ghcnd_search(stationid, date_min = NULL, date_max = NULL, var = "all",
  ...)
}
\arguments{
\item{stationid}{A character string giving the identification of the weather
station for which the user would like to pull data. To get a full and
current list of stations, the user can use the \code{\link{ghcnd_stations}}
function. To identify stations within a certain radius of a location, the
user can use the \code{\link{meteo_nearby_stations}} function.}

\item{date_min}{A character string giving the earliest
date of the daily weather time series that the user would
like in the final output. This character string should be formatted as
"yyyy-mm-dd". If not specified, the default is to keep all daily data for
the queried weather site from the earliest available date.}

\item{date_max}{A character string giving the latest
date of the daily weather time series that the user would
like in the final output. This character string should be formatted as
"yyyy-mm-dd". If not specified, the default is to keep all daily data for
the queried weather site through the most current available date.}

\item{var}{A character vector specifying either \code{"all"} (pull all
available weather parameters for the site) or the weather parameters to
keep in the final data (e.g., \code{c("TMAX", "TMIN")} to only keep
maximum and minimum temperature). Example choices for this argument
include:
\itemize{
\item \code{PRCP}: Precipitation, in tenths of millimeters
\item \code{TAVG}: Average temperature, in tenths of degrees Celsius
\item \code{TMAX}: Maximum temperature, in tenths of degrees Celsius
\item \code{TMIN}: Minimum temperature, in tenths of degrees Celsius
}
A full list of possible weather variables is available in NOAA's README
file for the GHCND data
(\url{http://www1.ncdc.noaa.gov/pub/data/ghcn/daily/readme.txt}).
Most weather stations will only have a small subset of all the possible
weather variables, so the data generated by this function may not include
all of the variables the user specifies through this argument.}

\item{...}{Additional curl options to pass through to \code{\link[httr]{GET}}.}
}
\value{
A list object with slots for each of the available specified
   weather variables. Each element in the list is a separate time series
   dataframe with daily observations, as well as flag values, for one of
   the weather variables. The flag values give information on the quality
   and source of each observation; see the NOAA README file linked above
   for more information.
}
\description{
This function uses ftp to access the Global Historical Climatology Network
daily weather data from NOAA's FTP server for a single weather monitor site.
It requires the site identification number for that site and will pull the
entire weather dataset for the site. It will then clean this data to convert
it to a tidier format and will also, if requested, filter it to a certain
date range and to certain weather variables.
}
\note{
This function calls \code{\link{ghcnd}}, which will download and save
   data from all available dates and weather variables for the queried
   weather station. The step of limiting the dataset to only certain dates
   and / or weather variables, using the \code{date_min}, \code{date_max},
   and \code{var} arguments, does not occur until after the full data has
   been pulled.
}
\examples{
\dontrun{
# Search based on variable and/or date
ghcnd_search("AGE00147704", var = "PRCP")
ghcnd_search("AGE00147704", var = "PRCP", date_min = "1920-01-01")
ghcnd_search("AGE00147704", var = "PRCP", date_max = "1915-01-01")
ghcnd_search("AGE00147704", var = "PRCP", date_min = "1920-01-01",
             date_max = "1925-01-01")
ghcnd_search("AGE00147704", date_min = "1920-01-01", date_max = "1925-01-01")
ghcnd_search("AGE00147704", var = c("PRCP","TMIN"))
ghcnd_search("AGE00147704", var = c("PRCP","TMIN"), date_min = "1920-01-01")
ghcnd_search("AGE00147704", var = "adfdf")
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com},
Adam Erickson \email{adam.erickson@ubc.ca}
}
\seealso{
\code{\link{meteo_pull_monitors}}, \code{\link{meteo_tidy_ghcnd}}
}

