% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomLR.R
\name{pivotCoord}
\alias{isomLR}
\alias{isomLRinv}
\alias{isomLRinvp}
\alias{isomLRp}
\alias{pivotCoord}
\alias{pivotCoordInv}
\title{Pivot coordinates and their inverse}
\usage{
pivotCoord(x, pivotvar = 1, fast = FALSE, method = "pivot",
  base = exp(1), norm = "orthonormal")

isomLR(x, fast = FALSE, base = exp(1), norm = "sqrt((D-i)/(D-i+1))")

isomLRinv(x)

pivotCoordInv(x, norm = "orthonormal")

isomLRp(x, fast = FALSE, base = exp(1), norm = "sqrt((D-i)/(D-i+1))")

isomLRinvp(x)
}
\arguments{
\item{x}{object of class data.frame or matrix. Positive values only.}

\item{pivotvar}{pivotal variable. If any other number than 1, the data are resorted in 
that sense that the pivotvar is shifted to the first part.}

\item{fast}{if TRUE, it is approx. 10 times faster but numerical problems in case of 
high-dimensional data numerical instabilities may occur. Only available for method \dQuote{pivot}.}

\item{method}{pivot takes the method described in the description. Method "symm" 
uses symmetric balances (parameters pivotvar and norm have then no effect)}

\item{base}{a positive or complex number: 
the base with respect to which logarithms are computed. Defaults to \code{exp(1)}.}

\item{norm}{if FALSE then the normalizing constant is not used, if TRUE \code{sqrt((D-i)/(D-i+1))} is 
used (default). The user can also specify a self-defined constant.}
}
\value{
The data represented in pivot coordinates
}
\description{
Isometric log-ratio transformations and it's inverse transformation with a 
special choice of balances.
}
\details{
This transformation moves D-part compositional data from the simplex
into a (D-1)-dimensional real space isometrically. From our choice of (pivot)
balances, all the relative information of one part is seperated from the
remaining parts.
}
\examples{

require(MASS)
Sigma <- matrix(c(5.05,4.95,4.95,5.05), ncol=2, byrow=TRUE)
z <- pivotCoordInv(mvrnorm(100, mu=c(0,2), Sigma=Sigma))

data(expenditures)
## first variable as pivot variable
pivotCoord(expenditures)
## third variable as pivot variable
pivotCoord(expenditures, 3) 

x <- exp(mvrnorm(2000, mu=rep(1,10), diag(10)))
system.time(pivotCoord(x))
system.time(pivotCoord(x, fast=TRUE))

## without normalizing constant
pivotCoord(expenditures, norm = "orthogonal") # or:
pivotCoord(expenditures, norm = "1")
## other normalization
pivotCoord(expenditures, norm = "-sqrt((D-i)/(D-i+1))")

# symmetric balances (results in 2-dim symmetric balances)
pivotCoord(expenditures, method = "symm")
}
\author{
Matthias Templ, Karel Hron, Peter Filzmoser
}
\references{
Egozcue J.J., V. Pawlowsky-Glahn, G. Mateu-Figueras and C.
Barcel'o-Vidal (2003) Isometric logratio transformations for compositional
data analysis. \emph{Mathematical Geology}, \bold{35}(3) 279-300. \

Hron, K. and Templ, M. and Filzmoser, P. (2010) Imputation of missing values
for compositional data using classical and robust methods

Kynclova, P., Hron, K., Filzmoser, P.
Correlation between compositional parts based on symmetric balances. Submitted to \emph{Mathematical Geosciences}.
\emph{Computational Statistics and Data Analysis}, vol 54 (12), pages
3095-3107.
}
\keyword{math}

