% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{manu_abs}
\alias{manu_abs}
\title{Distribution of manufacturing output}
\format{
A data frame with 630 observations of 4 variables.
}
\source{
Elaboration based on the INDSTAT 4 database (UNIDO 2012a), see also UNIDO, 2012b.
UNIDO (2012a), INDSTAT 4 Industrial Statistics Database at 3- and 4-digit level of 
ISIC Revision 3 and 4. Vienna. Available from http://stat.unido.org. 
UNIDO (2012b) International Yearbook of Industrial Statistics, Edward Elgar Publishing Ltd, UK.
}
\usage{
data(manu_abs)
}
\description{
The data consists of values of the manufacturing output in 42 countries in 2009. 
The output, given in national currencies, is structured according to the 
3-digit ISIC category and its components. 
Thorough analysis of the sample is described in Facevicova (2018).
}
\details{
\itemize{
\item{\code{country }}{Country}
\item{\code{isic }}{3-digit ISIC category. The categories are 
151 processed meat, fish, fruit, vegetables, fats; 
152 Dairy products; 
153 Grain mill products, starches, animal feeds; 
154 Other food products and 
155 Beverages. }
\item{\code{output }}{The output components are Labour, Surplus and Input.}
\item{\code{value}}{Value of manufacturing output in the national currency}
}
}
\examples{
data(manu_abs)

### Compositional tables approach
### analysis of the relative structure

result <- tabCoordWrapper(manu_abs, obs.ID='country',row.factor = 'output', 
col.factor = 'isic', value='value', test = TRUE)

result$Bootstrap

### Classical approach
### generalized linear mixed effect model
\dontrun{
library(lme4)
m <- glmer(value~output*as.factor(isic)+(1|country),
data=manu_abs,family=poisson)
summary(m)
}
}
\references{
Facevicova, K., Hron, K., Todorov, V. and M. Templ (2018) 
General approach to coordinate representation of compositional tables. 
Scandinavian Journal of Statistics, 45(4).
}
\author{
Kamila Facevicova
}
\keyword{data}
