% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{unemployed}
\alias{unemployed}
\title{unemployed of young people}
\format{
A (tidy) data frame with 1216 observations on the following 4 variables.
\itemize{ 
\item{\code{country }}{Country of origin}
\item{\code{age }}{age group } 
\item{\code{year }}{Year} 
\item{\code{value }}{percentage of unemployed}
}
}
\source{
OECD:
\url{https://data.oecd.org/}
}
\description{
Youth not in employment, education or training (NEET) in 43 countries from 1997 till 2015
}
\details{
This indicator presents the share of young people who are 
not in employment, education or training (NEET), as 
a percentage of the total number of young people 
in the corresponding age group, by gender. 
Young people in education include those attending 
part-time or full-time education, but exclude those 
in non-formal education and in educational activities 
of very short duration. Employment is defined according 
to the OECD/ILO Guidelines and covers all those who 
have been in paid work for at least one hour in the 
reference week of the survey or were temporarily 
absent from such work. Therefore NEET youth can be 
either unemployed or inactive and not involved in 
education or training. Young people who are neither 
in employment nor in education or training are at 
risk of becoming socially excluded - individuals 
with income below the poverty-line and lacking the 
skills to improve their economic situation.
}
\examples{

data(unemployed)
str(unemployed)
}
\references{
OECD (2017), Youth not in employment, education or training (NEET) (indicator). doi: 10.1787/72d1033a-en (Accessed on 27 March 2017)
}
\author{
translated from \url{https://data.oecd.org/} and restructured by Matthias Templ
}
\keyword{datasets}
